/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.plugin;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.plugin.PluginDefinition;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.service.plugin.JarHell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginClassLoader.class);
    public static final String PLUGIN_PATH = "META-INF/plugin.yaml";
    public static final String WINDOWS_PREFIX = "win";
    public static final int PLUGIN_DEF_CAPACITY = 1024;
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final File pluginDirectory;
    private final String osName;
    private Map<String, PluginDefinition> pluginDefinitionMap = new HashMap<String, PluginDefinition>();

    private PluginClassLoader(URL url, ClassLoader parent, String osName) throws IOException {
        super(new URL[]{url}, parent);
        this.pluginDirectory = new File(url.getPath());
        this.osName = osName;
        this.loadPluginDefinition();
    }

    public static PluginClassLoader getFromPluginUrl(final String url, final ClassLoader parent) {
        log.info("ClassLoaderPath : {}", (Object)url);
        PluginClassLoader.checkClassLoader(parent);
        PluginClassLoader.checkUrl(url);
        return AccessController.doPrivileged(new PrivilegedAction<PluginClassLoader>(){

            @Override
            public PluginClassLoader run() {
                String os = System.getProperty("os.name").toLowerCase();
                if (os.startsWith(PluginClassLoader.WINDOWS_PREFIX)) {
                    return new PluginClassLoader(new URL("file:///" + url), parent, os);
                }
                return new PluginClassLoader(new URL("file://" + url), parent, os);
            }
        });
    }

    private static void checkClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new RuntimeException("parent classLoader should not be null");
        }
    }

    private static void checkUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("url should not be empty");
        }
        File pluginDirectory = new File(url);
        if (!pluginDirectory.exists()) {
            throw new RuntimeException(String.format("pluginDirectory '%s' is not exists", pluginDirectory));
        }
        if (!pluginDirectory.isDirectory()) {
            throw new RuntimeException(String.format("pluginDirectory '%s' should be directory", pluginDirectory));
        }
        if (!pluginDirectory.canRead()) {
            throw new RuntimeException(String.format("pluginDirectory '%s' is not readable", pluginDirectory));
        }
    }

    public Map<String, PluginDefinition> getPluginDefinitions() {
        return this.pluginDefinitionMap;
    }

    private void loadPluginDefinition() throws IOException {
        File[] files = this.pluginDirectory.listFiles();
        if (files == null) {
            log.warn("plugin directory {} has no files", (Object)this.pluginDirectory);
            return;
        }
        ArrayList<PluginDefinition> definitions = new ArrayList<PluginDefinition>();
        for (File jarFile : files) {
            String jarName = jarFile.getName();
            if (!jarName.endsWith(".jar") || !jarName.contains("plugins-base")) {
                log.warn("invalid plugin jar {}, skip to load", (Object)jarFile);
                continue;
            }
            log.info("start to load valid plugin jar {}", (Object)jarFile);
            JarFile pluginJar = new JarFile(jarFile);
            String pluginDef = this.readPluginDef(pluginJar);
            pluginDef = pluginDef.replaceAll("[\\x00]+", "");
            PluginDefinition definition2 = (PluginDefinition)YAML_MAPPER.readValue(pluginDef, PluginDefinition.class);
            if (this.osName.startsWith(WINDOWS_PREFIX)) {
                super.addURL(new URL("file:///" + jarFile.getAbsolutePath()));
            } else {
                super.addURL(new URL("file://" + jarFile.getAbsolutePath()));
            }
            this.checkPluginValid(jarFile, definition2);
            definitions.add(definition2);
        }
        this.pluginDefinitionMap = definitions.stream().collect(Collectors.toMap(PluginDefinition::getName, definition -> definition));
    }

    private void checkPluginValid(File jarFile, PluginDefinition pluginDefinition) {
        String info = "[%s] not defined in plugin.yaml for " + jarFile.getName();
        Preconditions.expectNotBlank((String)pluginDefinition.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)String.format(info, "name"));
        Preconditions.expectNotEmpty((String)pluginDefinition.getJavaVersion(), (String)String.format(info, "javaVersion"));
        Preconditions.expectNotEmpty((Collection)pluginDefinition.getPluginClasses(), (String)String.format(info, "pluginClasses"));
        if (StringUtils.isEmpty((CharSequence)pluginDefinition.getDescription())) {
            log.warn(String.format(info, "description"));
        }
        for (String clazz : pluginDefinition.getPluginClasses()) {
            try {
                this.loadClass(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("plugin class %s not found in %s", clazz, jarFile.getName()));
            }
        }
        JarHell.checkJavaVersion(pluginDefinition.getName(), pluginDefinition.getJavaVersion());
    }

    private String readPluginDef(JarFile jar) throws IOException {
        JarEntry entry = jar.getJarEntry(PLUGIN_PATH);
        if (entry == null) {
            throw new RuntimeException(String.format("%s is not found in jar '%s'", PLUGIN_PATH, jar.getName()));
        }
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        try (InputStream is = jar.getInputStream(entry);){
            int bt;
            while ((bt = is.read()) != -1) {
                buffer.put((byte)bt);
            }
        }
        return new String(buffer.array(), StandardCharsets.UTF_8);
    }

    static {
        YAML_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        YAML_MAPPER.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        YAML_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

