/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.sort.node.EsNodeConfig;
import org.apache.inlong.common.pojo.sort.node.NodeConfig;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.es.ElasticsearchDataNodeDTO;
import org.apache.inlong.manager.pojo.node.es.ElasticsearchDataNodeInfo;
import org.apache.inlong.manager.pojo.node.es.ElasticsearchDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.sink.es.ElasticsearchApi;
import org.apache.inlong.manager.service.resource.sink.es.ElasticsearchConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchDataNodeOperator.class);
    public static final String KEY_PASSWORD = "password";
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "ELASTICSEARCH";
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        ElasticsearchDataNodeRequest esRequest = (ElasticsearchDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)esRequest, (Object)targetEntity, (boolean)true);
        try {
            ElasticsearchDataNodeDTO dto = ElasticsearchDataNodeDTO.getFromRequest((ElasticsearchDataNodeRequest)esRequest, (String)targetEntity.getExtParams());
            dto.setHttpHosts(request.getUrl());
            dto.setPassword(request.getToken());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for Elasticsearch node: %s", e.getMessage()));
        }
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        ElasticsearchDataNodeInfo info = new ElasticsearchDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)info);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            ElasticsearchDataNodeDTO dto = ElasticsearchDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)info);
        }
        return info;
    }

    @Override
    public Boolean testConnection(DataNodeRequest request) {
        String url = request.getUrl();
        String username = request.getUsername();
        String password = request.getToken();
        Preconditions.expectNotBlank((String)url, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"connection url cannot be empty");
        ElasticsearchApi client = new ElasticsearchApi();
        ElasticsearchConfig config = new ElasticsearchConfig();
        if (StringUtils.isNotEmpty((CharSequence)request.getUsername())) {
            config.setAuthEnable(true);
            config.setUsername(username);
            config.setPassword(password);
        }
        config.setHosts(url);
        client.setEsConfig(config);
        try {
            boolean result = client.ping();
            LOGGER.info("elasticsearch connection is {} for url={}, username={}, password={}", new Object[]{result, url, username, password});
            return result;
        }
        catch (Exception e) {
            String errMsg = String.format("elasticsearch connection failed for url=%s, username=%s, password=%s", url, username, password);
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }

    @Override
    public NodeConfig getNodeConfig(DataNodeEntity dataNodeEntity) {
        DataNodeInfo dataNodeInfo = this.getFromEntity(dataNodeEntity);
        ElasticsearchDataNodeDTO dto = ElasticsearchDataNodeDTO.getFromJson((String)dataNodeInfo.getExtParams());
        EsNodeConfig esNodeConfig = (EsNodeConfig)CommonBeanUtils.copyProperties((Object)dataNodeInfo, EsNodeConfig::new);
        CommonBeanUtils.copyProperties((Object)dto, (Object)esNodeConfig);
        esNodeConfig.setNodeName(dataNodeInfo.getName());
        return esNodeConfig;
    }
}

