/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.source;

import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.listener.source.AbstractSourceOperateListener;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SourceDeleteListener
extends AbstractSourceOperateListener {
    private static final Logger log = LoggerFactory.getLogger(SourceDeleteListener.class);

    public String name() {
        return this.getClass().getSimpleName();
    }

    public boolean accept(WorkflowContext context) {
        if (!this.isGroupProcessForm(context)) {
            return false;
        }
        GroupResourceProcessForm processForm = (GroupResourceProcessForm)context.getProcessForm();
        return InlongConstants.STANDARD_MODE.equals(processForm.getGroupInfo().getInlongGroupMode()) && processForm.getGroupOperateType() == GroupOperateType.DELETE;
    }

    @Override
    public void operateStreamSource(SourceRequest sourceRequest, String operator) {
        this.streamSourceService.delete(sourceRequest.getId(), operator);
    }
}

