/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.common.enums.ProcessStatus;
import org.apache.inlong.manager.common.threadPool.VisiableThreadPoolTaskExecutor;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.group.GroupFullInfo;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.pojo.workflow.form.process.ClusterResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InlongClusterProcessService {
    private static final Logger log = LoggerFactory.getLogger(InlongClusterProcessService.class);
    private static final ExecutorService EXECUTOR_SERVICE = new VisiableThreadPoolTaskExecutor(10, 20, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(10000), new ThreadFactoryBuilder().setNameFormat("inlong-cluster-process-%s").build(), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private WorkflowService workflowService;

    public boolean startProcess(String clusterTag, String operator, boolean sync) {
        log.info("start cluster process for clusterTag={}, operator={}", (Object)clusterTag, (Object)operator);
        ArrayList<GroupFullInfo> groupFullInfoList = new ArrayList<GroupFullInfo>();
        LoginUserUtils.getLoginUser().getRoles().add("INLONG_SERVICE");
        groupFullInfoList.addAll(this.groupService.getGroupByClusterTag(clusterTag));
        groupFullInfoList.addAll(this.groupService.getGroupByBackUpClusterTag(clusterTag));
        Preconditions.expectTrue((boolean)CollectionUtils.isNotEmpty(groupFullInfoList), (String)ErrorCodeEnum.GROUP_NOT_FOUND.getMessage());
        ClusterResourceProcessForm clusterResourceProcessForm = ClusterResourceProcessForm.getProcessForm((String)clusterTag, groupFullInfoList);
        LoginUserUtils.getLoginUser().getRoles().remove("INLONG_SERVICE");
        ProcessName processName = ProcessName.CREATE_CLUSTER_RESOURCE;
        if (sync) {
            WorkflowResult workflowResult = this.workflowService.start(processName, operator, (ProcessForm)clusterResourceProcessForm);
            ProcessStatus processStatus = workflowResult.getProcessInfo().getStatus();
            return processStatus == ProcessStatus.COMPLETED;
        }
        log.info("start cluster process for clusterTag={}, form={}", (Object)clusterTag, (Object)clusterResourceProcessForm);
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        EXECUTOR_SERVICE.execute(() -> this.workflowService.startAsync(processName, userInfo, (ProcessForm)clusterResourceProcessForm));
        return true;
    }
}

