/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.airflow.util;

import java.math.BigInteger;
import java.util.Objects;
import org.apache.inlong.manager.schedule.ScheduleUnit;

public class DateUtil {
    public static String intervalToSeconds(long interval, String timeUnit) {
        BigInteger seconds = new BigInteger(String.valueOf(interval));
        String intervalStr = "";
        switch (Objects.requireNonNull(ScheduleUnit.getScheduleUnit(timeUnit))) {
            case SECOND: {
                intervalStr = "1";
                break;
            }
            case MINUTE: {
                intervalStr = "60";
                break;
            }
            case HOUR: {
                intervalStr = "3600";
                break;
            }
            case DAY: {
                intervalStr = "86400";
                break;
            }
            case WEEK: {
                intervalStr = "604800";
                break;
            }
            case MONTH: {
                intervalStr = "2592000";
                break;
            }
            case YEAR: {
                intervalStr = "31536000";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported time unit");
            }
        }
        return seconds.multiply(new BigInteger(intervalStr)).toString();
    }
}

