/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.stream;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.pojo.common.PageRequest;

@ApiModel(value="Inlong stream paging query request")
public class TemplatePageRequest
extends PageRequest {
    @ApiModelProperty(value="Template name")
    @NotBlank(groups={SaveValidation.class}, message="template name cannot be blank")
    private @NotBlank(groups={SaveValidation.class}, message="template name cannot be blank") String name;
    @ApiModelProperty(value="Name of responsible person, separated by commas")
    private String inCharges;
    @ApiModelProperty(value="Visible range for template")
    private String visibleRange;
    @ApiModelProperty(value="Current user", hidden=true)
    private String currentUser;
    @ApiModelProperty(value="Inlong tenant name", hidden=true)
    private String tenant;
    @ApiModelProperty(value="weather is admin role.", hidden=true)
    private Boolean isAdminRole;

    public static TemplatePageRequestBuilder builder() {
        return new TemplatePageRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public String getVisibleRange() {
        return this.visibleRange;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public String getTenant() {
        return this.tenant;
    }

    public Boolean getIsAdminRole() {
        return this.isAdminRole;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setVisibleRange(String visibleRange) {
        this.visibleRange = visibleRange;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setIsAdminRole(Boolean isAdminRole) {
        this.isAdminRole = isAdminRole;
    }

    public String toString() {
        return "TemplatePageRequest(name=" + this.getName() + ", inCharges=" + this.getInCharges() + ", visibleRange=" + this.getVisibleRange() + ", currentUser=" + this.getCurrentUser() + ", tenant=" + this.getTenant() + ", isAdminRole=" + this.getIsAdminRole() + ")";
    }

    public TemplatePageRequest() {
    }

    public TemplatePageRequest(String name, String inCharges, String visibleRange, String currentUser, String tenant, Boolean isAdminRole) {
        this.name = name;
        this.inCharges = inCharges;
        this.visibleRange = visibleRange;
        this.currentUser = currentUser;
        this.tenant = tenant;
        this.isAdminRole = isAdminRole;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplatePageRequest)) {
            return false;
        }
        TemplatePageRequest other = (TemplatePageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isAdminRole = this.getIsAdminRole();
        Boolean other$isAdminRole = other.getIsAdminRole();
        if (this$isAdminRole == null ? other$isAdminRole != null : !((Object)this$isAdminRole).equals(other$isAdminRole)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        String this$visibleRange = this.getVisibleRange();
        String other$visibleRange = other.getVisibleRange();
        if (this$visibleRange == null ? other$visibleRange != null : !this$visibleRange.equals(other$visibleRange)) {
            return false;
        }
        String this$currentUser = this.getCurrentUser();
        String other$currentUser = other.getCurrentUser();
        if (this$currentUser == null ? other$currentUser != null : !this$currentUser.equals(other$currentUser)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemplatePageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isAdminRole = this.getIsAdminRole();
        result = result * 59 + ($isAdminRole == null ? 43 : ((Object)$isAdminRole).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        String $visibleRange = this.getVisibleRange();
        result = result * 59 + ($visibleRange == null ? 43 : $visibleRange.hashCode());
        String $currentUser = this.getCurrentUser();
        result = result * 59 + ($currentUser == null ? 43 : $currentUser.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }

    public static class TemplatePageRequestBuilder {
        private String name;
        private String inCharges;
        private String visibleRange;
        private String currentUser;
        private String tenant;
        private Boolean isAdminRole;

        TemplatePageRequestBuilder() {
        }

        public TemplatePageRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TemplatePageRequestBuilder inCharges(String inCharges) {
            this.inCharges = inCharges;
            return this;
        }

        public TemplatePageRequestBuilder visibleRange(String visibleRange) {
            this.visibleRange = visibleRange;
            return this;
        }

        public TemplatePageRequestBuilder currentUser(String currentUser) {
            this.currentUser = currentUser;
            return this;
        }

        public TemplatePageRequestBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public TemplatePageRequestBuilder isAdminRole(Boolean isAdminRole) {
            this.isAdminRole = isAdminRole;
            return this;
        }

        public TemplatePageRequest build() {
            return new TemplatePageRequest(this.name, this.inCharges, this.visibleRange, this.currentUser, this.tenant, this.isAdminRole);
        }

        public String toString() {
            return "TemplatePageRequest.TemplatePageRequestBuilder(name=" + this.name + ", inCharges=" + this.inCharges + ", visibleRange=" + this.visibleRange + ", currentUser=" + this.currentUser + ", tenant=" + this.tenant + ", isAdminRole=" + this.isAdminRole + ")";
        }
    }
}

