/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.schedule.airflow;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
@ApiModel(description="DAGRunConf Description Information.")
public class DAGRunConf {
    @JsonProperty(value="inlong_group_id")
    @ApiModelProperty(value="Specify the Inlong group ID")
    private String inlongGroupId;
    @JsonProperty(value="start_time")
    @ApiModelProperty(value="The start time of DAG scheduling.")
    private long startTime;
    @JsonProperty(value="end_time")
    @ApiModelProperty(value="The end time of DAG scheduling.")
    private long endTime;
    @JsonProperty(value="boundary_type")
    @ApiModelProperty(value="The offline task boundary type.")
    private String boundaryType;
    @JsonProperty(value="cron_expr")
    @ApiModelProperty(value="Cron expression.")
    private String cronExpr;
    @JsonProperty(value="seconds_interval")
    @ApiModelProperty(value="Time interval (in seconds).")
    private String secondsInterval;
    @JsonProperty(value="connection_id")
    @ApiModelProperty(value="Airflow Connection Id of Inlong Manager.")
    private String connectionId;
    @JsonProperty(value="timezone")
    @ApiModelProperty(value="The timezone.")
    private String timezone;

    public static DAGRunConfBuilder builder() {
        return new DAGRunConfBuilder();
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getBoundaryType() {
        return this.boundaryType;
    }

    public String getCronExpr() {
        return this.cronExpr;
    }

    public String getSecondsInterval() {
        return this.secondsInterval;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="inlong_group_id")
    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    @JsonProperty(value="start_time")
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @JsonProperty(value="end_time")
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @JsonProperty(value="boundary_type")
    public void setBoundaryType(String boundaryType) {
        this.boundaryType = boundaryType;
    }

    @JsonProperty(value="cron_expr")
    public void setCronExpr(String cronExpr) {
        this.cronExpr = cronExpr;
    }

    @JsonProperty(value="seconds_interval")
    public void setSecondsInterval(String secondsInterval) {
        this.secondsInterval = secondsInterval;
    }

    @JsonProperty(value="connection_id")
    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    @JsonProperty(value="timezone")
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DAGRunConf)) {
            return false;
        }
        DAGRunConf other = (DAGRunConf)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$boundaryType = this.getBoundaryType();
        String other$boundaryType = other.getBoundaryType();
        if (this$boundaryType == null ? other$boundaryType != null : !this$boundaryType.equals(other$boundaryType)) {
            return false;
        }
        String this$cronExpr = this.getCronExpr();
        String other$cronExpr = other.getCronExpr();
        if (this$cronExpr == null ? other$cronExpr != null : !this$cronExpr.equals(other$cronExpr)) {
            return false;
        }
        String this$secondsInterval = this.getSecondsInterval();
        String other$secondsInterval = other.getSecondsInterval();
        if (this$secondsInterval == null ? other$secondsInterval != null : !this$secondsInterval.equals(other$secondsInterval)) {
            return false;
        }
        String this$connectionId = this.getConnectionId();
        String other$connectionId = other.getConnectionId();
        if (this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        return !(this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DAGRunConf;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $boundaryType = this.getBoundaryType();
        result = result * 59 + ($boundaryType == null ? 43 : $boundaryType.hashCode());
        String $cronExpr = this.getCronExpr();
        result = result * 59 + ($cronExpr == null ? 43 : $cronExpr.hashCode());
        String $secondsInterval = this.getSecondsInterval();
        result = result * 59 + ($secondsInterval == null ? 43 : $secondsInterval.hashCode());
        String $connectionId = this.getConnectionId();
        result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        return result;
    }

    public String toString() {
        return "DAGRunConf(inlongGroupId=" + this.getInlongGroupId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", boundaryType=" + this.getBoundaryType() + ", cronExpr=" + this.getCronExpr() + ", secondsInterval=" + this.getSecondsInterval() + ", connectionId=" + this.getConnectionId() + ", timezone=" + this.getTimezone() + ")";
    }

    public DAGRunConf() {
    }

    public DAGRunConf(String inlongGroupId, long startTime, long endTime, String boundaryType, String cronExpr, String secondsInterval, String connectionId, String timezone) {
        this.inlongGroupId = inlongGroupId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.boundaryType = boundaryType;
        this.cronExpr = cronExpr;
        this.secondsInterval = secondsInterval;
        this.connectionId = connectionId;
        this.timezone = timezone;
    }

    public static class DAGRunConfBuilder {
        private String inlongGroupId;
        private long startTime;
        private long endTime;
        private String boundaryType;
        private String cronExpr;
        private String secondsInterval;
        private String connectionId;
        private String timezone;

        DAGRunConfBuilder() {
        }

        @JsonProperty(value="inlong_group_id")
        public DAGRunConfBuilder inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return this;
        }

        @JsonProperty(value="start_time")
        public DAGRunConfBuilder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        @JsonProperty(value="end_time")
        public DAGRunConfBuilder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        @JsonProperty(value="boundary_type")
        public DAGRunConfBuilder boundaryType(String boundaryType) {
            this.boundaryType = boundaryType;
            return this;
        }

        @JsonProperty(value="cron_expr")
        public DAGRunConfBuilder cronExpr(String cronExpr) {
            this.cronExpr = cronExpr;
            return this;
        }

        @JsonProperty(value="seconds_interval")
        public DAGRunConfBuilder secondsInterval(String secondsInterval) {
            this.secondsInterval = secondsInterval;
            return this;
        }

        @JsonProperty(value="connection_id")
        public DAGRunConfBuilder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        @JsonProperty(value="timezone")
        public DAGRunConfBuilder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public DAGRunConf build() {
            return new DAGRunConf(this.inlongGroupId, this.startTime, this.endTime, this.boundaryType, this.cronExpr, this.secondsInterval, this.connectionId, this.timezone);
        }

        public String toString() {
            return "DAGRunConf.DAGRunConfBuilder(inlongGroupId=" + this.inlongGroupId + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", boundaryType=" + this.boundaryType + ", cronExpr=" + this.cronExpr + ", secondsInterval=" + this.secondsInterval + ", connectionId=" + this.connectionId + ", timezone=" + this.timezone + ")";
        }
    }
}

