/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.flink.configuration.Configuration;
import org.apache.inlong.manager.plugin.flink.dto.FlinkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(FlinkServiceUtils.class);
    private static final String DEFAULT_PLUGINS = "plugins";
    private static final String FILE_PREFIX = "file://";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getFlinkClientService(Configuration configuration, FlinkConfig flinkConfig) {
        log.info("Flink version {}", (Object)flinkConfig.getVersion());
        Path pluginPath = Paths.get(DEFAULT_PLUGINS, new String[0]).toAbsolutePath();
        String flinkJarName = String.format("manager-plugins-flink-v%s.jar", flinkConfig.getVersion());
        String flinkClientPath = FILE_PREFIX + pluginPath + File.separator + flinkJarName;
        log.info("Start to load Flink jar: {}", (Object)flinkClientPath);
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{new URL(flinkClientPath)}, Thread.currentThread().getContextClassLoader());){
            Class<?> flinkClientService = classLoader.loadClass("org.apache.inlong.manager.plugin.flink.FlinkClientService");
            Object flinkService = flinkClientService.getDeclaredConstructor(Configuration.class).newInstance(configuration);
            log.info("Successfully loaded Flink service");
            Object obj = flinkService;
            return obj;
        }
        catch (Exception e) {
            log.error("Failed to loaded Flink service, please check flink client jar path: {}", (Object)flinkClientPath);
            throw new RuntimeException(e);
        }
    }
}

