/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.apache.inlong.manager.plugin.flink.dto.FlinkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlinkConfiguration.class);
    private static final String DEFAULT_CONFIG_FILE = "flink-sort-plugin.properties";
    private static final String INLONG_MANAGER = "inlong-manager";
    private final FlinkConfig flinkConfig;

    public FlinkConfiguration() throws Exception {
        String path = this.formatPath();
        this.flinkConfig = this.getFlinkConfigFromFile(path);
    }

    private String formatPath() throws Exception {
        String path = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        LOGGER.info("format first path {}", (Object)path);
        int index = path.indexOf(INLONG_MANAGER);
        if (index == -1) {
            throw new Exception("inlong-manager path not found in " + path);
        }
        String confPath = (path = path.substring(0, index)) + INLONG_MANAGER + File.separator + "plugins" + File.separator + DEFAULT_CONFIG_FILE;
        File file = new File(confPath);
        if (!file.exists()) {
            String message = String.format("not found %s in path %s", DEFAULT_CONFIG_FILE, confPath);
            LOGGER.error(message);
            throw new Exception(message);
        }
        LOGGER.info("after format, {} located in {}", (Object)DEFAULT_CONFIG_FILE, (Object)confPath);
        return confPath;
    }

    public FlinkConfig getFlinkConfig() {
        return this.flinkConfig;
    }

    private FlinkConfig getFlinkConfigFromFile(String fileName) throws IOException {
        Properties properties = new Properties();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));
        properties.load(bufferedReader);
        FlinkConfig flinkConfig = new FlinkConfig();
        flinkConfig.setPort(Integer.valueOf(properties.getProperty("flink.rest.port")));
        flinkConfig.setAddress(properties.getProperty("flink.rest.address"));
        flinkConfig.setParallelism(Integer.valueOf(properties.getProperty("flink.parallelism")));
        flinkConfig.setSavepointDirectory(properties.getProperty("flink.savepoint.directory"));
        flinkConfig.setJobManagerPort(Integer.valueOf(properties.getProperty("flink.jobmanager.port")));
        flinkConfig.setDrain(Boolean.parseBoolean(properties.getProperty("flink.drain")));
        flinkConfig.setAuditProxyHosts(properties.getProperty("metrics.audit.proxy.hosts"));
        flinkConfig.setVersion(properties.getProperty("flink.version"));
        return flinkConfig;
    }
}

