/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.threadPool;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisiableThreadPoolTaskExecutor
extends ThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(VisiableThreadPoolTaskExecutor.class);

    public VisiableThreadPoolTaskExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    private void showThreadPoolInfo(String prefix) {
        logger.info("Current thread pool class = {}, opType = {}, taskCount = {}, completedTaskCount = {}, activeCount = {}, poolSize = {}, queueSize = {}", new Object[]{this.getThreadFactory().getClass(), prefix, this.getTaskCount(), this.getCompletedTaskCount(), this.getActiveCount(), this.getPoolSize(), this.getQueue().size()});
    }

    @Override
    public void execute(Runnable task) {
        this.showThreadPoolInfo("execute");
        super.execute(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.showThreadPoolInfo("submit");
        return super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.showThreadPoolInfo("submit");
        return super.submit(task);
    }
}

