/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import java.util.Locale;

public enum TransformType {
    STRING_REPLACER("string_replacer"),
    SPLITTER("splitter"),
    FILTER("filter"),
    DE_DUPLICATION("de_duplication"),
    JOINER("joiner"),
    LOOKUP_JOINER("lookup_joiner"),
    TEMPORAL_JOINER("temporal_joiner"),
    INTERVAL_JOINER("interval_joiner"),
    ENCRYPT("encrypt");

    private final String type;

    private TransformType(String type) {
        this.type = type;
    }

    public static TransformType forType(String type) {
        for (TransformType transformType : TransformType.values()) {
            if (!transformType.getType().equals(type) && !transformType.getType().toUpperCase(Locale.ROOT).equals(type)) continue;
            return transformType;
        }
        throw new IllegalArgumentException(String.format("Unsupported transformType=%s", type));
    }

    public String getType() {
        return this.type;
    }
}

