/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.InlongGroupApi;
import org.apache.inlong.manager.client.api.service.InlongSortApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SimpleGroupStatus;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.BatchResult;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.group.InlongGroupBriefInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupCountResponse;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupPageRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupResetRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicRequest;
import org.apache.inlong.manager.pojo.schedule.OfflineJobRequest;
import org.apache.inlong.manager.pojo.sort.SortStatusInfo;
import org.apache.inlong.manager.pojo.sort.SortStatusRequest;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import retrofit2.Call;

public class InlongGroupClient {
    private final InlongGroupApi inlongGroupApi;
    private final InlongSortApi inlongSortApi;

    public InlongGroupClient(ClientConfiguration configuration) {
        this.inlongGroupApi = (InlongGroupApi)ClientUtils.createRetrofit(configuration).create(InlongGroupApi.class);
        this.inlongSortApi = (InlongSortApi)ClientUtils.createRetrofit(configuration).create(InlongSortApi.class);
    }

    public Boolean isGroupExists(String inlongGroupId) {
        Preconditions.expectNotBlank((String)inlongGroupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongGroupApi.isGroupExists(inlongGroupId));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public InlongGroupInfo getGroupIfExists(String inlongGroupId) {
        if (this.isGroupExists(inlongGroupId).booleanValue()) {
            return this.getGroupInfo(inlongGroupId);
        }
        return null;
    }

    public InlongGroupInfo getGroupInfo(String inlongGroupId) {
        Preconditions.expectNotBlank((String)inlongGroupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Response<Object> responseBody = ClientUtils.executeHttpCall(this.inlongGroupApi.getGroupInfo(inlongGroupId));
        if (responseBody.isSuccess()) {
            JSONObject groupInfoJson = (JSONObject)JsonUtils.parseObject((String)JsonUtils.toJsonString((Object)JsonUtils.toJsonString((Object)responseBody.getData())), JSONObject.class);
            assert (groupInfoJson != null);
            if (groupInfoJson.has("middlewareType") && !groupInfoJson.has("mqType")) {
                groupInfoJson.put("mqType", groupInfoJson.get("middlewareType"));
            }
            return (InlongGroupInfo)JsonUtils.parseObject((String)groupInfoJson.toString(), InlongGroupInfo.class);
        }
        if (responseBody.getErrMsg().contains("not exist")) {
            return null;
        }
        throw new RuntimeException(responseBody.getErrMsg());
    }

    public PageResult<InlongGroupBriefInfo> listGroups(String keyword, int status, int pageNum, int pageSize) {
        InlongGroupPageRequest request = InlongGroupPageRequest.builder().keyword(keyword).status(Integer.valueOf(status)).build();
        request.setPageNum(pageNum <= 0 ? 1 : pageNum);
        request.setPageSize(pageSize);
        Response<PageResult<InlongGroupBriefInfo>> pageInfoResponse = ClientUtils.executeHttpCall(this.inlongGroupApi.listGroups(request));
        if (pageInfoResponse.isSuccess()) {
            return (PageResult)pageInfoResponse.getData();
        }
        if (pageInfoResponse.getErrMsg().contains("not exist")) {
            return null;
        }
        throw new RuntimeException(pageInfoResponse.getErrMsg());
    }

    public PageResult<InlongGroupBriefInfo> listGroups(InlongGroupPageRequest pageRequest) {
        Response<PageResult<InlongGroupBriefInfo>> response = ClientUtils.executeHttpCall(this.inlongGroupApi.listGroups(pageRequest));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public List<SortStatusInfo> listSortStatus(SortStatusRequest request) {
        Response<List<SortStatusInfo>> response = ClientUtils.executeHttpCall(this.inlongSortApi.listStatus(request));
        ClientUtils.assertRespSuccess(response);
        return (List)response.getData();
    }

    public String createGroup(InlongGroupRequest groupInfo) {
        Response<String> response = ClientUtils.executeHttpCall(this.inlongGroupApi.createGroup(groupInfo));
        ClientUtils.assertRespSuccess(response);
        return (String)response.getData();
    }

    public List<BatchResult> batchCreateGroup(List<InlongGroupRequest> groupRequestList) {
        Response<List<BatchResult>> response = ClientUtils.executeHttpCall(this.inlongGroupApi.batchCreateGroup(groupRequestList));
        ClientUtils.assertRespSuccess(response);
        return (List)response.getData();
    }

    public Pair<String, String> updateGroup(InlongGroupRequest groupRequest) {
        Response<String> response = ClientUtils.executeHttpCall(this.inlongGroupApi.updateGroup(groupRequest));
        return Pair.of((Object)response.getData(), (Object)response.getErrMsg());
    }

    public boolean resetGroup(InlongGroupResetRequest resetRequest) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongGroupApi.resetGroup(resetRequest));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public WorkflowResult startProcess(InlongGroupRequest groupInfo) {
        Response<WorkflowResult> responseBody = ClientUtils.executeHttpCall(this.inlongGroupApi.startProcess(groupInfo.getInlongGroupId()));
        ClientUtils.assertRespSuccess(responseBody);
        return (WorkflowResult)responseBody.getData();
    }

    public WorkflowResult batchStartProcess(List<InlongGroupRequest> groupRequestList) {
        List<String> groupIdList = groupRequestList.stream().map(InlongGroupRequest::getInlongGroupId).collect(Collectors.toList());
        Response<WorkflowResult> responseBody = ClientUtils.executeHttpCall(this.inlongGroupApi.batchStartProcess(groupIdList));
        ClientUtils.assertRespSuccess(responseBody);
        return (WorkflowResult)responseBody.getData();
    }

    public boolean operateInlongGroup(String groupId, SimpleGroupStatus status) {
        return this.operateInlongGroup(groupId, status, false);
    }

    public boolean operateInlongGroup(String groupId, SimpleGroupStatus status, boolean async) {
        Call<Response<WorkflowResult>> responseCall;
        if (async) {
            return this.operateInlongGroupAsync(groupId, status);
        }
        if (status == SimpleGroupStatus.STOPPED) {
            responseCall = this.inlongGroupApi.suspendProcess(groupId);
        } else if (status == SimpleGroupStatus.STARTED) {
            responseCall = this.inlongGroupApi.restartProcess(groupId);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported inlong group status: %s", status));
        }
        Response<WorkflowResult> responseBody = ClientUtils.executeHttpCall(responseCall);
        String errMsg = responseBody.getErrMsg();
        return responseBody.isSuccess() || errMsg == null || !errMsg.contains("not allowed");
    }

    public boolean operateInlongGroupAsync(String groupId, SimpleGroupStatus status) {
        Call<Response<String>> responseCall;
        if (status == SimpleGroupStatus.STOPPED) {
            responseCall = this.inlongGroupApi.suspendProcessAsync(groupId);
        } else if (status == SimpleGroupStatus.STARTED) {
            responseCall = this.inlongGroupApi.restartProcessAsync(groupId);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported inlong group status: %s", status));
        }
        Response<String> responseBody = ClientUtils.executeHttpCall(responseCall);
        String errMsg = responseBody.getErrMsg();
        return responseBody.isSuccess() || errMsg == null || !errMsg.contains("not allowed");
    }

    public boolean deleteInlongGroup(String groupId) {
        return this.deleteInlongGroup(groupId, false);
    }

    public boolean deleteInlongGroup(String groupId, boolean async) {
        if (async) {
            Response<String> response = ClientUtils.executeHttpCall(this.inlongGroupApi.deleteGroupAsync(groupId));
            ClientUtils.assertRespSuccess(response);
            return groupId.equals(response.getData());
        }
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongGroupApi.deleteGroup(groupId));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public InlongGroupCountResponse countGroupByUser() {
        Response<Object> response = ClientUtils.executeHttpCall(this.inlongGroupApi.countGroupByUser());
        if (response.isSuccess()) {
            return (InlongGroupCountResponse)JsonUtils.parseObject((String)JsonUtils.toJsonString((Object)response.getData()), InlongGroupCountResponse.class);
        }
        if (response.getErrMsg().contains("not exist")) {
            return null;
        }
        throw new RuntimeException(response.getErrMsg());
    }

    public InlongGroupTopicInfo getTopic(String id) {
        Response<Object> response = ClientUtils.executeHttpCall(this.inlongGroupApi.getTopic(id));
        if (response.isSuccess()) {
            return (InlongGroupTopicInfo)JsonUtils.parseObject((String)JsonUtils.toJsonString((Object)response.getData()), InlongGroupTopicInfo.class);
        }
        if (response.getErrMsg().contains("not exist")) {
            return null;
        }
        throw new RuntimeException(response.getErrMsg());
    }

    public String getTenant(String groupId) {
        Response<String> response = ClientUtils.executeHttpCall(this.inlongGroupApi.getTenant(groupId));
        if (response.isSuccess()) {
            return (String)response.getData();
        }
        if (response.getErrMsg().contains("not exist")) {
            return null;
        }
        throw new RuntimeException(response.getErrMsg());
    }

    public List<InlongGroupTopicInfo> listTopics(InlongGroupTopicRequest request) {
        Response<List<InlongGroupTopicInfo>> response = ClientUtils.executeHttpCall(this.inlongGroupApi.listTopics(request));
        if (response.isSuccess()) {
            return (List)response.getData();
        }
        if (response.getErrMsg().contains("not exist")) {
            return null;
        }
        throw new RuntimeException(response.getErrMsg());
    }

    public Boolean startTagSwitch(String groupId, String clusterTag) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongGroupApi.startTagSwitch(groupId, clusterTag));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Boolean finishTagSwitch(String groupId) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongGroupApi.finishTagSwitch(groupId));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Boolean submitOfflineJob(OfflineJobRequest request) {
        Response<Boolean> responseBody = ClientUtils.executeHttpCall(this.inlongGroupApi.submitOfflineJob(request));
        ClientUtils.assertRespSuccess(responseBody);
        return (Boolean)responseBody.getData();
    }
}

