/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.InLongScheduleApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfo;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfoRequest;

public class InLongScheduleClient {
    private InLongScheduleApi scheduleApi;

    public InLongScheduleClient(ClientConfiguration clientConfiguration) {
        this.scheduleApi = (InLongScheduleApi)ClientUtils.createRetrofit(clientConfiguration).create(InLongScheduleApi.class);
    }

    public Integer createScheduleInfo(ScheduleInfoRequest request) {
        Response<Integer> response = ClientUtils.executeHttpCall(this.scheduleApi.createSchedule(request));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public Boolean scheduleInfoExist(String groupId) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Response<Boolean> response = ClientUtils.executeHttpCall(this.scheduleApi.exist(groupId));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Boolean updateScheduleInfo(ScheduleInfoRequest request) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.scheduleApi.update(request));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public ScheduleInfo getScheduleInfo(String groupId) {
        Response<ScheduleInfo> response = ClientUtils.executeHttpCall(this.scheduleApi.get(groupId));
        ClientUtils.assertRespSuccess(response);
        return (ScheduleInfo)response.getData();
    }

    public Boolean deleteScheduleInfo(String groupId) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.scheduleApi.delete(groupId));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }
}

