/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.client.api.inner.client.InlongGroupClient;
import org.apache.inlong.manager.client.cli.AbstractCommand;
import org.apache.inlong.manager.client.cli.AbstractCommandRunner;
import org.apache.inlong.manager.client.cli.pojo.GroupInfo;
import org.apache.inlong.manager.client.cli.util.ClientUtils;
import org.apache.inlong.manager.client.cli.util.PrintUtils;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.group.InlongGroupPageRequest;

@Parameters(commandDescription="Log resource")
public class LogCommand
extends AbstractCommand {
    @Parameter
    private List<String> params;

    public LogCommand() {
        super("log");
        this.jcommander.addCommand("group", (Object)new CreateGroup());
    }

    @Parameters(commandDescription="Log group")
    private static class CreateGroup
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"--query"}, required=true, description="condition filters")
        private String input;

        private CreateGroup() {
        }

        @Override
        void run() {
            int MAX_LOG_SIZE = 100;
            try {
                if (StringUtils.isNotBlank((CharSequence)this.input)) {
                    System.err.println("input cannot be empty, for example: inlongGroupId:test_group");
                    return;
                }
                String[] inputs = this.input.split(":");
                if (inputs.length < 2 || StringUtils.isBlank((CharSequence)inputs[1])) {
                    System.err.println("the input must contain ':'");
                    return;
                }
                ClientUtils.initClientFactory();
                InlongGroupClient groupClient = ClientUtils.clientFactory.getGroupClient();
                InlongGroupPageRequest pageRequest = new InlongGroupPageRequest();
                pageRequest.setKeyword(inputs[1]);
                PageResult pageResult = groupClient.listGroups(pageRequest);
                if (pageResult.getPageSize() > 100) {
                    System.err.println("the log is too large to print, please change the filter condition");
                    return;
                }
                PrintUtils.print(pageResult.getList(), GroupInfo.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

