/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dirtydata;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.StringJoiner;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirtyMessageWrapper {
    private static final Logger log = LoggerFactory.getLogger(DirtyMessageWrapper.class);
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private String delimiter;
    private int retryTimes;
    private String inlongGroupId;
    private String inlongStreamId;
    private long dataTime;
    private String dataflowId;
    private String serverType;
    private String dirtyType;
    private String dirtyMessage;
    private String ext;
    private String data;
    private byte[] dataBytes;

    public String format() {
        String reportTime = LocalDateTime.now().format(dateTimeFormatter);
        StringJoiner joiner = new StringJoiner(this.delimiter);
        String formatData = null;
        if (this.data != null) {
            formatData = this.data;
        } else if (this.dataBytes != null) {
            formatData = Base64.getEncoder().encodeToString(this.dataBytes);
        }
        String dataTimeStr = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.dataTime), ZoneId.systemDefault()).format(dateTimeFormatter);
        return joiner.add(this.dataflowId).add(this.inlongGroupId).add(this.inlongStreamId).add(reportTime).add(dataTimeStr).add(this.serverType).add(this.dirtyType).add(StringEscapeUtils.escapeXSI((String)this.dirtyMessage)).add(StringEscapeUtils.escapeXSI((String)this.ext)).add(StringEscapeUtils.escapeXSI((String)formatData)).toString();
    }

    public void increaseRetry() {
        ++this.retryTimes;
    }

    private static String $default$delimiter() {
        return "|";
    }

    private static int $default$retryTimes() {
        return 0;
    }

    DirtyMessageWrapper(String delimiter, int retryTimes, String inlongGroupId, String inlongStreamId, long dataTime, String dataflowId, String serverType, String dirtyType, String dirtyMessage, String ext, String data, byte[] dataBytes) {
        this.delimiter = delimiter;
        this.retryTimes = retryTimes;
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamId = inlongStreamId;
        this.dataTime = dataTime;
        this.dataflowId = dataflowId;
        this.serverType = serverType;
        this.dirtyType = dirtyType;
        this.dirtyMessage = dirtyMessage;
        this.ext = ext;
        this.data = data;
        this.dataBytes = dataBytes;
    }

    public static DirtyMessageWrapperBuilder builder() {
        return new DirtyMessageWrapperBuilder();
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public static class DirtyMessageWrapperBuilder {
        private boolean delimiter$set;
        private String delimiter$value;
        private boolean retryTimes$set;
        private int retryTimes$value;
        private String inlongGroupId;
        private String inlongStreamId;
        private long dataTime;
        private String dataflowId;
        private String serverType;
        private String dirtyType;
        private String dirtyMessage;
        private String ext;
        private String data;
        private byte[] dataBytes;

        DirtyMessageWrapperBuilder() {
        }

        public DirtyMessageWrapperBuilder delimiter(String delimiter) {
            this.delimiter$value = delimiter;
            this.delimiter$set = true;
            return this;
        }

        public DirtyMessageWrapperBuilder retryTimes(int retryTimes) {
            this.retryTimes$value = retryTimes;
            this.retryTimes$set = true;
            return this;
        }

        public DirtyMessageWrapperBuilder inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return this;
        }

        public DirtyMessageWrapperBuilder inlongStreamId(String inlongStreamId) {
            this.inlongStreamId = inlongStreamId;
            return this;
        }

        public DirtyMessageWrapperBuilder dataTime(long dataTime) {
            this.dataTime = dataTime;
            return this;
        }

        public DirtyMessageWrapperBuilder dataflowId(String dataflowId) {
            this.dataflowId = dataflowId;
            return this;
        }

        public DirtyMessageWrapperBuilder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        public DirtyMessageWrapperBuilder dirtyType(String dirtyType) {
            this.dirtyType = dirtyType;
            return this;
        }

        public DirtyMessageWrapperBuilder dirtyMessage(String dirtyMessage) {
            this.dirtyMessage = dirtyMessage;
            return this;
        }

        public DirtyMessageWrapperBuilder ext(String ext) {
            this.ext = ext;
            return this;
        }

        public DirtyMessageWrapperBuilder data(String data) {
            this.data = data;
            return this;
        }

        public DirtyMessageWrapperBuilder dataBytes(byte[] dataBytes) {
            this.dataBytes = dataBytes;
            return this;
        }

        public DirtyMessageWrapper build() {
            String delimiter$value = this.delimiter$value;
            if (!this.delimiter$set) {
                delimiter$value = DirtyMessageWrapper.$default$delimiter();
            }
            int retryTimes$value = this.retryTimes$value;
            if (!this.retryTimes$set) {
                retryTimes$value = DirtyMessageWrapper.$default$retryTimes();
            }
            return new DirtyMessageWrapper(delimiter$value, retryTimes$value, this.inlongGroupId, this.inlongStreamId, this.dataTime, this.dataflowId, this.serverType, this.dirtyType, this.dirtyMessage, this.ext, this.data, this.dataBytes);
        }

        public String toString() {
            return "DirtyMessageWrapper.DirtyMessageWrapperBuilder(delimiter$value=" + this.delimiter$value + ", retryTimes$value=" + this.retryTimes$value + ", inlongGroupId=" + this.inlongGroupId + ", inlongStreamId=" + this.inlongStreamId + ", dataTime=" + this.dataTime + ", dataflowId=" + this.dataflowId + ", serverType=" + this.serverType + ", dirtyType=" + this.dirtyType + ", dirtyMessage=" + this.dirtyMessage + ", ext=" + this.ext + ", data=" + this.data + ", dataBytes=" + Arrays.toString(this.dataBytes) + ")";
        }
    }
}

