/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flume.Context;
import org.apache.inlong.dataproxy.config.DefaultManagerIpListParser;
import org.apache.inlong.dataproxy.config.IManagerIpListParser;
import org.apache.inlong.dataproxy.sink.common.DefaultEventHandler;
import org.apache.inlong.dataproxy.sink.mq.AllCacheClusterSelector;
import org.apache.inlong.sdk.commons.protocol.ProxySdk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonConfigHolder {
    public static final Logger LOG = LoggerFactory.getLogger(CommonConfigHolder.class);
    public static final String COMMON_CONFIG_FILE_NAME = "common.properties";
    public static final String KEY_PROXY_CLUSTER_TAG = "proxy.cluster.tag";
    public static final String VAL_DEF_CLUSTER_TAG = "default_cluster";
    public static final String KEY_PROXY_CLUSTER_NAME = "proxy.cluster.name";
    public static final String VAL_DEF_CLUSTER_NAME = "default_dataproxy";
    public static final String KEY_PROXY_CLUSTER_INCHARGES = "proxy.cluster.inCharges";
    public static final String VAL_DEF_CLUSTER_INCHARGES = "admin";
    public static final String KEY_PROXY_CLUSTER_EXT_TAG = "proxy.cluster.extTag";
    public static final String VAL_DEF_CLUSTER_EXT_TAG = "default=true";
    public static final String KEY_MANAGER_TYPE = "manager.type";
    public static final String VAL_DEF_MANAGER_TYPE = DefaultManagerIpListParser.class.getName();
    public static final String KEY_MANAGER_HOSTS = "manager.hosts";
    public static final String KEY_MANAGER_HOSTS_SEPARATOR = ",";
    public static final String KEY_MANAGER_AUTH_SECRET_ID = "manager.auth.secretId";
    public static final String KEY_MANAGER_AUTH_SECRET_KEY = "manager.auth.secretKey";
    private static final String KEY_META_CONFIG_SYNC_INTERVAL_MS = "meta.config.sync.interval.ms";
    private static final String KEY_CONFIG_CHECK_INTERVAL_MS = "configCheckInterval";
    public static final long VAL_DEF_CONFIG_SYNC_INTERVAL_MS = 60000L;
    public static final long VAL_MIN_CONFIG_SYNC_INTERVAL_MS = 10000L;
    private static final String KEY_META_CONFIG_SYNC_WAST_ALARM_MS = "meta.config.sync.wast.alarm.ms";
    public static final long VAL_DEF_META_CONFIG_SYNC_WAST_ALARM_MS = 30000L;
    private static final String KEY_ENABLE_STARTUP_USING_LOCAL_META_FILE = "startup.using.local.meta.file.enable";
    public static final boolean VAL_DEF_ENABLE_STARTUP_USING_LOCAL_META_FILE = false;
    public static final String KEY_ENABLE_UNCONFIGURED_TOPIC_ACCEPT = "id2topic.unconfigured.accept.enable";
    public static final boolean VAL_DEF_ENABLE_UNCONFIGURED_TOPIC_ACCEPT = false;
    public static final String KEY_UNCONFIGURED_TOPIC_DEFAULT_TOPICS = "id2topic.unconfigured.default.topics";
    public static final String VAL_DEFAULT_TOPIC = "test";
    public static final String KEY_ENABLE_WHITELIST = "proxy.enable.whitelist";
    public static final boolean VAL_DEF_ENABLE_WHITELIST = false;
    public static final String KEY_ENABLE_FILE_METRIC = "file.metric.enable";
    public static final boolean VAL_DEF_ENABLE_FILE_METRIC = true;
    public static final String KEY_FILE_METRIC_STAT_INTERVAL_SEC = "file.metric.stat.interval.sec";
    public static final int VAL_DEF_FILE_METRIC_STAT_INVL_SEC = 60;
    public static final int VAL_MIN_FILE_METRIC_STAT_INVL_SEC = 0;
    public static final String KEY_FILE_METRIC_MAX_CACHE_CNT = "file.metric.max.cache.cnt";
    public static final int VAL_DEF_FILE_METRIC_MAX_CACHE_CNT = 1000000;
    public static final int VAL_MIN_FILE_METRIC_MAX_CACHE_CNT = 0;
    public static final String KEY_FILE_METRIC_SOURCE_OUTPUT_NAME = "file.metric.source.output.name";
    public static final String VAL_DEF_FILE_METRIC_SOURCE_OUTPUT_NAME = "Source";
    public static final String KEY_FILE_METRIC_SINK_OUTPUT_NAME = "file.metric.sink.output.name";
    public static final String VAL_DEF_FILE_METRIC_SINK_OUTPUT_NAME = "Sink";
    public static final String KEY_FILE_METRIC_EVENT_OUTPUT_NAME = "file.metric.event.output.name";
    public static final String VAL_DEF_FILE_METRIC_EVENT_OUTPUT_NAME = "Stats";
    public static final String KEY_ENABLE_AUDIT = "audit.enable";
    public static final boolean VAL_DEF_ENABLE_AUDIT = true;
    public static final String KEY_AUDIT_PROXYS = "audit.proxys";
    public static final String KEY_AUDIT_FILE_PATH = "audit.filePath";
    public static final String VAL_DEF_AUDIT_FILE_PATH = "/data/inlong/audit/";
    public static final String KEY_AUDIT_MAX_CACHE_ROWS = "audit.maxCacheRows";
    public static final int VAL_DEF_AUDIT_MAX_CACHE_ROWS = 2000000;
    public static final String KEY_AUDIT_FORMAT_INTERVAL_MS = "auditFormatInterval";
    public static final long VAL_DEF_AUDIT_FORMAT_INTERVAL_MS = 60000L;
    public static final String KEY_ENABLE_SEND_RETRY_AFTER_FAILURE = "send.retry.after.failure";
    public static final boolean VAL_DEF_ENABLE_SEND_RETRY_AFTER_FAILURE = true;
    public static final String KEY_MAX_RETRIES_AFTER_FAILURE = "max.retries.after.failure";
    public static final int VAL_DEF_MAX_RETRIES_AFTER_FAILURE = -1;
    public static final String KEY_RESPONSE_AFTER_SAVE = "isResponseAfterSave";
    public static final boolean VAL_DEF_RESPONSE_AFTER_SAVE = false;
    public static final String KEY_MAX_RAS_TIMEOUT_MS = "maxRASTimeoutMs";
    public static final long VAL_DEF_MAX_RAS_TIMEOUT_MS = 10000L;
    public static final String KEY_MAX_BUFFERQUEUE_SIZE_KB = "maxBufferQueueSizeKb";
    public static final int VAL_DEF_MAX_BUFFERQUEUE_SIZE_KB = 131072;
    public static final String KEY_EVENT_HANDLER = "eventHandler";
    public static final String VAL_DEF_EVENT_HANDLER = DefaultEventHandler.class.getName();
    public static final String KEY_CACHE_CLUSTER_SELECTOR = "cacheClusterSelector";
    public static final String VAL_DEF_CACHE_CLUSTER_SELECTOR = AllCacheClusterSelector.class.getName();
    public static final String KEY_PROXY_NODE_ID = "nodeId";
    public static final String VAL_DEF_PROXY_NODE_ID = "127.0.0.1";
    public static final String KEY_MSG_SENT_COMPRESS_TYPE = "compressType";
    public static final String VAL_DEF_MSG_COMPRESS_TYPE = ProxySdk.INLONG_COMPRESSED_TYPE.INLONG_SNAPPY.name();
    public static final String KEY_PROMETHEUS_HTTP_PORT = "prometheusHttpPort";
    public static final int VAL_DEF_PROMETHEUS_HTTP_PORT = 8080;
    private static CommonConfigHolder instance = null;
    private static volatile boolean isInit = false;
    private Map<String, String> props;
    private String clusterTag = "default_cluster";
    private String clusterName = "default_dataproxy";
    private String clusterIncharges = "admin";
    private String clusterExtTag = "default=true";
    private String managerType = VAL_DEF_MANAGER_TYPE;
    private IManagerIpListParser ipListParser = null;
    private String managerAuthSecretId = "";
    private String managerAuthSecretKey = "";
    private boolean enableStartupUsingLocalMetaFile = false;
    private long metaConfigSyncInvlMs = 60000L;
    private long metaConfigWastAlarmMs = 30000L;
    private boolean enableAudit = true;
    private final HashSet<String> auditProxys = new HashSet();
    private String auditFilePath = "/data/inlong/audit/";
    private int auditMaxCacheRows = 2000000;
    private long auditFormatInvlMs = 60000L;
    private boolean responseAfterSave = false;
    private long maxResAfterSaveTimeout = 10000L;
    private boolean enableUnConfigTopicAccept = false;
    private List<String> defaultTopics = Arrays.asList("test");
    private boolean enableWhiteList = false;
    private int maxBufferQueueSizeKb = 131072;
    private String eventHandler = VAL_DEF_EVENT_HANDLER;
    private String cacheClusterSelector = VAL_DEF_CACHE_CLUSTER_SELECTOR;
    private String proxyNodeId = "127.0.0.1";
    private String msgCompressType = VAL_DEF_MSG_COMPRESS_TYPE;
    private int prometheusHttpPort = 8080;
    private boolean enableFileMetric = true;
    private int fileMetricStatInvlSec = 60;
    private int fileMetricStatCacheCnt = 1000000;
    private String fileMetricSourceOutName = "Source";
    private String fileMetricSinkOutName = "Sink";
    private String fileMetricEventOutName = "Stats";
    private boolean enableSendRetryAfterFailure = true;
    private int maxRetriesAfterFailure = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonConfigHolder getInstance() {
        if (isInit && instance != null) {
            return instance;
        }
        Class<CommonConfigHolder> clazz = CommonConfigHolder.class;
        synchronized (CommonConfigHolder.class) {
            if (!isInit) {
                instance = new CommonConfigHolder();
                if (instance.loadConfigFile()) {
                    instance.preReadFields();
                }
                isInit = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Map<String, String> getProperties() {
        return this.props;
    }

    public static String getStringFromContext(Context context, String key, String defaultValue) {
        String value = context.getString(key);
        value = value != null ? value : CommonConfigHolder.getInstance().getProperties().getOrDefault(key, defaultValue);
        return value;
    }

    public String getClusterTag() {
        return this.clusterTag;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterIncharges() {
        return this.clusterIncharges;
    }

    public String getClusterExtTag() {
        return this.clusterExtTag;
    }

    public long getMetaConfigSyncInvlMs() {
        return this.metaConfigSyncInvlMs;
    }

    public long getMetaConfigWastAlarmMs() {
        return this.metaConfigWastAlarmMs;
    }

    public boolean isEnableUnConfigTopicAccept() {
        return this.enableUnConfigTopicAccept;
    }

    public List<String> getDefTopics() {
        return this.defaultTopics;
    }

    public String getRandDefTopics() {
        if (this.defaultTopics.isEmpty()) {
            return null;
        }
        SecureRandom rand = new SecureRandom();
        return this.defaultTopics.get(rand.nextInt(this.defaultTopics.size()));
    }

    public boolean isEnableWhiteList() {
        return this.enableWhiteList;
    }

    public String getManagerType() {
        return this.managerType;
    }

    public List<String> getManagerHosts() {
        return this.ipListParser.getIpList();
    }

    public String getManagerAuthSecretId() {
        return this.managerAuthSecretId;
    }

    public String getManagerAuthSecretKey() {
        return this.managerAuthSecretKey;
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public boolean isEnableFileMetric() {
        return this.enableFileMetric;
    }

    public int getFileMetricStatInvlSec() {
        return this.fileMetricStatInvlSec;
    }

    public int getFileMetricStatCacheCnt() {
        return this.fileMetricStatCacheCnt;
    }

    public HashSet<String> getAuditProxys() {
        return this.auditProxys;
    }

    public String getAuditFilePath() {
        return this.auditFilePath;
    }

    public int getAuditMaxCacheRows() {
        return this.auditMaxCacheRows;
    }

    public long getAuditFormatInvlMs() {
        return this.auditFormatInvlMs;
    }

    public boolean isResponseAfterSave() {
        return this.responseAfterSave;
    }

    public long getMaxResAfterSaveTimeout() {
        return this.maxResAfterSaveTimeout;
    }

    public int getMaxBufferQueueSizeKb() {
        return this.maxBufferQueueSizeKb;
    }

    public boolean isEnableStartupUsingLocalMetaFile() {
        return this.enableStartupUsingLocalMetaFile;
    }

    public String getEventHandler() {
        return this.eventHandler;
    }

    public String getCacheClusterSelector() {
        return this.cacheClusterSelector;
    }

    public int getPrometheusHttpPort() {
        return this.prometheusHttpPort;
    }

    public String getProxyNodeId() {
        return this.proxyNodeId;
    }

    public String getMsgCompressType() {
        return this.msgCompressType;
    }

    public String getFileMetricSourceOutName() {
        return this.fileMetricSourceOutName;
    }

    public String getFileMetricSinkOutName() {
        return this.fileMetricSinkOutName;
    }

    public String getFileMetricEventOutName() {
        return this.fileMetricEventOutName;
    }

    public boolean isEnableSendRetryAfterFailure() {
        return this.enableSendRetryAfterFailure;
    }

    public int getMaxRetriesAfterFailure() {
        return this.maxRetriesAfterFailure;
    }

    private void preReadFields() {
        int retries;
        int maxCacheCnt;
        int statInvl;
        long tmpSyncInvMs;
        String tmpValue = this.props.get(KEY_PROXY_CLUSTER_TAG);
        if (StringUtils.isNotBlank((CharSequence)tmpValue)) {
            this.clusterTag = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_PROXY_CLUSTER_NAME)))) {
            this.clusterName = tmpValue.trim();
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_PROXY_CLUSTER_INCHARGES)))) {
            this.clusterIncharges = tmpValue.trim();
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_PROXY_CLUSTER_EXT_TAG)))) {
            this.clusterExtTag = tmpValue.trim();
        }
        if (StringUtils.isBlank((CharSequence)(tmpValue = this.props.get(KEY_META_CONFIG_SYNC_INTERVAL_MS)))) {
            tmpValue = this.props.get(KEY_CONFIG_CHECK_INTERVAL_MS);
        }
        if (StringUtils.isNotEmpty((CharSequence)tmpValue) && (tmpSyncInvMs = NumberUtils.toLong((String)tmpValue.trim(), (long)60000L)) >= 10000L) {
            this.metaConfigSyncInvlMs = tmpSyncInvMs;
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_META_CONFIG_SYNC_WAST_ALARM_MS)))) {
            this.metaConfigWastAlarmMs = NumberUtils.toLong((String)tmpValue.trim(), (long)30000L);
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_ENABLE_STARTUP_USING_LOCAL_META_FILE)))) {
            this.enableStartupUsingLocalMetaFile = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_ENABLE_UNCONFIGURED_TOPIC_ACCEPT)))) {
            this.enableUnConfigTopicAccept = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_UNCONFIGURED_TOPIC_DEFAULT_TOPICS)))) {
            String[] topicItems;
            ArrayList<String> tmpList = new ArrayList<String>();
            String[] stringArray = topicItems = tmpValue.split(",|\\s+");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String item = stringArray[i];
                if (StringUtils.isBlank((CharSequence)item)) continue;
                tmpList.add(item.trim());
            }
            if (tmpList.size() > 0) {
                this.defaultTopics = tmpList;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_ENABLE_WHITELIST)))) {
            this.enableWhiteList = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_MANAGER_TYPE)))) {
            this.managerType = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_MANAGER_AUTH_SECRET_ID)))) {
            this.managerAuthSecretId = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_MANAGER_AUTH_SECRET_KEY)))) {
            this.managerAuthSecretKey = tmpValue.trim();
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_ENABLE_FILE_METRIC)))) {
            this.enableFileMetric = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_FILE_METRIC_STAT_INTERVAL_SEC))) && (statInvl = NumberUtils.toInt((String)tmpValue.trim(), (int)60)) >= 0) {
            this.fileMetricStatInvlSec = statInvl;
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_FILE_METRIC_MAX_CACHE_CNT))) && (maxCacheCnt = NumberUtils.toInt((String)tmpValue.trim(), (int)1000000)) >= 0) {
            this.fileMetricStatCacheCnt = maxCacheCnt;
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_FILE_METRIC_SOURCE_OUTPUT_NAME)))) {
            this.fileMetricSourceOutName = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_FILE_METRIC_SINK_OUTPUT_NAME)))) {
            this.fileMetricSinkOutName = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_FILE_METRIC_EVENT_OUTPUT_NAME)))) {
            this.fileMetricEventOutName = tmpValue.trim();
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_ENABLE_AUDIT)))) {
            this.enableAudit = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_AUDIT_PROXYS)))) {
            String[] ipPorts;
            for (String tmpIPPort : ipPorts = tmpValue.split("\\s+")) {
                if (StringUtils.isBlank((CharSequence)tmpIPPort)) continue;
                this.auditProxys.add(tmpIPPort.trim());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_AUDIT_FILE_PATH)))) {
            this.auditFilePath = tmpValue.trim();
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_AUDIT_MAX_CACHE_ROWS)))) {
            this.auditMaxCacheRows = NumberUtils.toInt((String)tmpValue.trim(), (int)2000000);
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_AUDIT_FORMAT_INTERVAL_MS)))) {
            this.auditFormatInvlMs = NumberUtils.toLong((String)tmpValue.trim(), (long)60000L);
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_RESPONSE_AFTER_SAVE)))) {
            this.responseAfterSave = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_MAX_RAS_TIMEOUT_MS)))) {
            this.maxResAfterSaveTimeout = NumberUtils.toLong((String)tmpValue.trim(), (long)10000L);
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_MAX_BUFFERQUEUE_SIZE_KB)))) {
            this.maxBufferQueueSizeKb = NumberUtils.toInt((String)tmpValue.trim(), (int)131072);
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_EVENT_HANDLER)))) {
            this.eventHandler = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_CACHE_CLUSTER_SELECTOR)))) {
            this.cacheClusterSelector = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_PROXY_NODE_ID)))) {
            this.proxyNodeId = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_MSG_SENT_COMPRESS_TYPE)))) {
            this.msgCompressType = tmpValue.trim();
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_PROMETHEUS_HTTP_PORT)))) {
            this.prometheusHttpPort = NumberUtils.toInt((String)tmpValue.trim(), (int)8080);
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_ENABLE_SEND_RETRY_AFTER_FAILURE)))) {
            this.enableSendRetryAfterFailure = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_MAX_RETRIES_AFTER_FAILURE))) && (retries = NumberUtils.toInt((String)tmpValue.trim(), (int)-1)) >= 0) {
            this.maxRetriesAfterFailure = retries;
        }
        try {
            Class<?> ipListParserClass = Class.forName(this.managerType);
            this.ipListParser = (IManagerIpListParser)ipListParserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.ipListParser.setCommonProperties(this.props);
        }
        catch (Throwable t) {
            LOG.error("Initial ipListParser Class {} failure, exit!", (Object)this.managerType, (Object)t);
            System.exit(6);
        }
    }

    private void chkRequiredFields(String requiredFieldKey) {
        String fieldVal = this.props.get(requiredFieldKey);
        if (fieldVal == null) {
            LOG.error("Missing mandatory field {} in {}, exit!", (Object)requiredFieldKey, (Object)COMMON_CONFIG_FILE_NAME);
            System.exit(4);
        }
        if (StringUtils.isBlank((CharSequence)fieldVal)) {
            LOG.error("Required {} field value is blank in {}, exit!", (Object)requiredFieldKey, (Object)COMMON_CONFIG_FILE_NAME);
            System.exit(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadConfigFile() {
        InputStream inStream = null;
        try {
            URL url = this.getClass().getClassLoader().getResource(COMMON_CONFIG_FILE_NAME);
            InputStream inputStream = inStream = url != null ? url.openStream() : null;
            if (inStream == null) {
                LOG.error("Fail to open {} as the input stream is null, exit!", (Object)COMMON_CONFIG_FILE_NAME);
                System.exit(1);
                boolean bl = false;
                return bl;
            }
            Properties tmpProps = new Properties();
            tmpProps.load(inStream);
            this.props = new HashMap<String, String>(tmpProps.size());
            for (Map.Entry<Object, Object> entry : tmpProps.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                String strKey = (String)entry.getKey();
                String strVal = (String)entry.getValue();
                if (StringUtils.isBlank((CharSequence)strKey) || StringUtils.isBlank((CharSequence)strVal)) continue;
                this.props.put(strKey.trim(), strVal.trim());
            }
            LOG.info("Read success from {}, content is {}", (Object)COMMON_CONFIG_FILE_NAME, this.props);
        }
        catch (Throwable e) {
            LOG.error("Fail to load properties from {}, exit!", (Object)COMMON_CONFIG_FILE_NAME, (Object)e);
            System.exit(2);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOG.error("Fail to InputStream.close() for file {}, exit!", (Object)COMMON_CONFIG_FILE_NAME, (Object)e);
                    System.exit(3);
                }
            }
        }
        return true;
    }
}

