/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.utils;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzUtils {
    private static final Logger logger = LoggerFactory.getLogger(AuthzUtils.class);
    private static final LogCounter exptCounter = new LogCounter(10L, 200000L, 60000L);

    public static String generateSignature(String secureId, long timestamp, int randomValue, String secureKey) {
        String result;
        block2: {
            Base64 base64 = new Base64();
            byte[] baseStr = base64.encode(HmacUtils.hmacSha1((String)secureKey, (String)(secureId + timestamp + randomValue)));
            result = "";
            try {
                result = URLEncoder.encode(new String(baseStr), StandardCharsets.UTF_8.toString());
            }
            catch (Throwable ex) {
                if (!exptCounter.shouldPrint()) break block2;
                logger.warn("Generate signature throw exception", ex);
            }
        }
        return result;
    }
}

