/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.sender.http;

import org.apache.inlong.sdk.dataproxy.MsgSenderFactory;
import org.apache.inlong.sdk.dataproxy.common.ErrorCode;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.common.SdkConsts;
import org.apache.inlong.sdk.dataproxy.network.http.HttpAsyncObj;
import org.apache.inlong.sdk.dataproxy.network.http.HttpClientMgr;
import org.apache.inlong.sdk.dataproxy.sender.BaseSender;
import org.apache.inlong.sdk.dataproxy.sender.MsgSendCallback;
import org.apache.inlong.sdk.dataproxy.sender.http.HttpEventInfo;
import org.apache.inlong.sdk.dataproxy.sender.http.HttpMsgSender;
import org.apache.inlong.sdk.dataproxy.sender.http.HttpMsgSenderConfig;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;

public class InLongHttpMsgSender
extends BaseSender
implements HttpMsgSender {
    protected static final LogCounter httpExceptCnt = new LogCounter(10L, 100000L, 60000L);
    private final HttpClientMgr httpClientMgr;
    private final HttpMsgSenderConfig httpConfig;

    public InLongHttpMsgSender(HttpMsgSenderConfig configure) {
        this(configure, null, null);
    }

    public InLongHttpMsgSender(HttpMsgSenderConfig configure, MsgSenderFactory senderFactory, String clusterIdKey) {
        super(configure, senderFactory, clusterIdKey);
        this.httpConfig = (HttpMsgSenderConfig)this.baseConfig;
        this.clientMgr = new HttpClientMgr(this, this.httpConfig);
        this.httpClientMgr = (HttpClientMgr)this.clientMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean syncSendMessage(HttpEventInfo eventInfo, ProcessResult procResult) {
        this.validParamsNotNull(eventInfo, procResult);
        if (!this.isStarted()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        long curTime = System.currentTimeMillis();
        try {
            if (this.isMetaInfoUnReady()) {
                boolean bl = procResult.setFailResult(ErrorCode.NO_NODE_META_INFOS);
                return bl;
            }
            if (!this.isValidPkgLength(eventInfo, this.getAllowedPkgLength(), procResult)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.httpClientMgr.sendMessage(eventInfo, procResult);
            return bl;
        }
        finally {
            if (procResult.isSuccess()) {
                this.metricHolder.addSyncSucMetric(eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt(), System.currentTimeMillis() - curTime);
            } else {
                this.metricHolder.addSyncFailMetric(procResult.getErrCode(), eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean asyncSendMessage(HttpEventInfo eventInfo, MsgSendCallback callback, ProcessResult procResult) {
        this.validParamsNotNull(eventInfo, callback, procResult);
        if (!this.isStarted()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        boolean gotPermits = false;
        try {
            if (this.isMetaInfoUnReady()) {
                boolean bl = procResult.setFailResult(ErrorCode.NO_NODE_META_INFOS);
                return bl;
            }
            if (!this.tryAcquireCachePermits(eventInfo.getBodySize(), procResult)) {
                boolean bl = false;
                return bl;
            }
            gotPermits = true;
            if (!this.isValidPkgLength(eventInfo, this.getAllowedPkgLength(), procResult)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.httpClientMgr.asyncSendMessage(new HttpAsyncObj(eventInfo, callback), procResult);
            return bl;
        }
        finally {
            if (procResult.isSuccess()) {
                this.metricHolder.addAsyncHttpSucPutMetric(eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt());
            } else {
                if (gotPermits) {
                    this.releaseCachePermits(eventInfo.getBodySize());
                }
                this.metricHolder.addAsyncHttpFailPutMetric(procResult.getErrCode(), eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt());
            }
        }
    }

    @Override
    public int getActiveNodeCnt() {
        return this.httpClientMgr.getActiveNodeCnt();
    }

    @Override
    public int getInflightMsgCnt() {
        return this.httpClientMgr.getInflightMsgCnt();
    }

    private boolean isValidPkgLength(HttpEventInfo eventInfo, int allowedLen, ProcessResult procResult) {
        if (allowedLen < 0) {
            return true;
        }
        int eventLen = eventInfo.getBodySize() + eventInfo.getGroupId().length() + eventInfo.getStreamId().length() + String.valueOf(eventInfo.getDtMs()).length();
        if (eventLen > allowedLen - SdkConsts.RESERVED_ATTRIBUTE_LENGTH) {
            String errMsg = String.format("OverMaxLen: content length(%d) > allowedLen(%d) - fixedLen(%d)", eventLen, allowedLen, SdkConsts.RESERVED_ATTRIBUTE_LENGTH);
            if (httpExceptCnt.shouldPrint()) {
                logger.warn(errMsg);
            }
            return procResult.setFailResult(ErrorCode.REPORT_INFO_EXCEED_MAX_LEN, errMsg);
        }
        return true;
    }

    private void validParamsNotNull(HttpEventInfo eventInfo, ProcessResult procResult) {
        if (eventInfo == null) {
            throw new NullPointerException("eventInfo is null");
        }
        if (procResult == null) {
            throw new NullPointerException("procResult is null");
        }
    }

    private void validParamsNotNull(HttpEventInfo eventInfo, MsgSendCallback callback, ProcessResult procResult) {
        if (eventInfo == null) {
            throw new NullPointerException("eventInfo is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is null");
        }
        if (procResult == null) {
            throw new NullPointerException("procResult is null");
        }
    }
}

