/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network.tcp.codec;

import java.util.List;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.dataproxy.shaded.io.netty.buffer.ByteBuf;
import org.apache.inlong.dataproxy.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.inlong.dataproxy.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.inlong.dataproxy.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import org.apache.inlong.sdk.dataproxy.network.tcp.codec.EncodeObject;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolEncoder
extends MessageToMessageEncoder<EncodeObject> {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolEncoder.class);
    private static final LogCounter exptCounter = new LogCounter(10L, 100000L, 60000L);

    @Override
    protected void encode(ChannelHandlerContext ctx, EncodeObject encObject, List<Object> out) throws Exception {
        ByteBuf buf;
        block19: {
            buf = null;
            try {
                if (encObject.getMsgType() == MsgType.MSG_ACK_SERVICE) {
                    int totalLength = 9 + encObject.getMsgSize();
                    buf = ByteBufAllocator.DEFAULT.buffer(4 + totalLength);
                    buf.writeInt(totalLength);
                    buf.writeByte(encObject.getIntMsgType());
                    buf.writeInt(encObject.getBodyDataLength());
                    if (encObject.getBodyDataLength() > 0) {
                        buf.writeBytes(encObject.getBodyData());
                    }
                    buf.writeInt(encObject.getAttrDataLength());
                    if (encObject.getAttrDataLength() > 0) {
                        buf.writeBytes(encObject.getAttrData());
                    }
                } else if (encObject.getMsgType() == MsgType.MSG_MULTI_BODY) {
                    int totalLength = 9 + encObject.getMsgSize();
                    buf = ByteBufAllocator.DEFAULT.buffer(4 + totalLength);
                    buf.writeInt(totalLength);
                    buf.writeByte(encObject.getIntMsgType());
                    buf.writeInt(encObject.getBodyDataLength());
                    if (encObject.getBodyDataLength() > 0) {
                        buf.writeBytes(encObject.getBodyData());
                    }
                    buf.writeInt(encObject.getAttrDataLength());
                    if (encObject.getAttrDataLength() > 0) {
                        buf.writeBytes(encObject.getAttrData());
                    }
                } else if (encObject.getMsgType() == MsgType.MSG_BIN_MULTI_BODY) {
                    int totalLength = 25 + encObject.getMsgSize();
                    buf = ByteBufAllocator.DEFAULT.buffer(4 + totalLength);
                    buf.writeInt(totalLength);
                    buf.writeByte(encObject.getIntMsgType());
                    buf.writeShort(encObject.getGroupIdNum());
                    buf.writeShort(encObject.getStreamIdNum());
                    buf.writeShort(encObject.getExtField());
                    buf.writeInt((int)encObject.getDtMs());
                    buf.writeShort(encObject.getMsgCnt());
                    buf.writeInt(encObject.getMessageId());
                    buf.writeInt(encObject.getBodyDataLength());
                    if (encObject.getBodyDataLength() > 0) {
                        buf.writeBytes(encObject.getBodyData());
                    }
                    buf.writeShort(encObject.getAttrDataLength());
                    if (encObject.getAttrDataLength() > 0) {
                        buf.writeBytes(encObject.getAttrData());
                    }
                    buf.writeShort(60929);
                } else if (encObject.getMsgType() == MsgType.MSG_BIN_HEARTBEAT) {
                    int totalLength = 12 + encObject.getAttrDataLength() + 2;
                    buf = ByteBufAllocator.DEFAULT.buffer(4 + totalLength);
                    buf.writeInt(totalLength);
                    buf.writeByte(encObject.getIntMsgType());
                    buf.writeInt((int)encObject.getDtMs());
                    buf.writeByte(2);
                    buf.writeInt(0);
                    buf.writeShort(encObject.getAttrDataLength());
                    if (encObject.getAttrDataLength() > 0) {
                        buf.writeBytes(encObject.getAttrData());
                    }
                    buf.writeShort(60929);
                }
            }
            catch (Throwable ex) {
                if (!exptCounter.shouldPrint()) break block19;
                logger.warn("ProtocolEncoder encode({}) message failure", (Object)encObject.getMsgType(), (Object)ex);
            }
        }
        if (buf != null) {
            out.add(buf);
        } else if (exptCounter.shouldPrint()) {
            logger.warn("ProtocolEncoder write({}) buffer is null!", (Object)encObject.getMsgType());
        }
    }
}

