/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.tool.task;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.audit.tool.config.AppConfig;
import org.apache.inlong.audit.tool.dto.AuditAlertRule;
import org.apache.inlong.audit.tool.evaluator.AlertEvaluator;
import org.apache.inlong.audit.tool.manager.AuditAlertRuleManager;
import org.apache.inlong.audit.tool.service.AuditMetricService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditCheckTask {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final AlertEvaluator alertEvaluator;
    private final AuditAlertRuleManager auditAlertRuleManager;
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditCheckTask.class);
    private final AuditMetricService auditMetricService;
    private Integer executionIntervalTime = 1;
    private Integer intervalTimeMinute = 1;
    private final Integer delayTimeMinute;
    private static final DateTimeFormatter LOGS_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private String sourceAuditId = "5";

    public AuditCheckTask(AuditAlertRuleManager auditAlertRuleManager, AlertEvaluator alertEvaluator, AppConfig appConfig) {
        this.auditAlertRuleManager = auditAlertRuleManager;
        this.alertEvaluator = alertEvaluator;
        this.auditMetricService = new AuditMetricService();
        try {
            this.executionIntervalTime = Integer.valueOf(appConfig.getProperties().getProperty("audit.data.time.delay.minute", "1"));
            this.intervalTimeMinute = Integer.parseInt(appConfig.getProperties().getProperty("audit.data.time.interval.minute", "1"));
            this.sourceAuditId = appConfig.getProperties().getProperty("audit.id.source", "5");
        }
        catch (Exception e) {
            LOGGER.error("Failed to read configuration information, default source AuditId is 5, delay execution time is 1, time interval is 1");
        }
        this.delayTimeMinute = this.executionIntervalTime;
    }

    public void start() {
        this.scheduler.scheduleAtFixedRate(() -> this.checkAuditData(), 0L, this.executionIntervalTime.intValue(), TimeUnit.MINUTES);
    }

    private void checkAuditData() {
        String endLogTs;
        List sinkAuditIds = this.auditAlertRuleManager.getAuditIds();
        if (sinkAuditIds == null) {
            return;
        }
        List alertRules = this.auditAlertRuleManager.getAuditAlertRuleList();
        String startLogTs = this.getStartLogTs();
        List sourceAuditMetric = this.auditMetricService.getStorageAuditMetrics(this.sourceAuditId, startLogTs, endLogTs = this.getEndLogTs());
        if (sourceAuditMetric == null) {
            return;
        }
        for (String sinkAuditId : sinkAuditIds) {
            List sinkAuditMetrics = this.auditMetricService.getStorageAuditMetrics(sinkAuditId, startLogTs, endLogTs);
            if (sinkAuditMetrics == null || sinkAuditMetrics.isEmpty()) continue;
            for (AuditAlertRule alertRule : alertRules) {
                this.alertEvaluator.evaluateAndReportAlert(sourceAuditMetric, sinkAuditMetrics, alertRule);
            }
        }
    }

    public void stop() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private String getStartLogTs() {
        return LocalDateTime.now().withSecond(0).minusMinutes(this.delayTimeMinute.intValue()).minusMinutes(this.intervalTimeMinute.intValue()).format(LOGS_FMT);
    }

    private String getEndLogTs() {
        return LocalDateTime.now().withSecond(0).minusMinutes(this.delayTimeMinute.intValue()).format(LOGS_FMT);
    }
}

