/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.tool.evaluator;

import java.util.List;
import java.util.Objects;
import org.apache.inlong.audit.tool.dto.AuditAlertCondition;
import org.apache.inlong.audit.tool.dto.AuditAlertRule;
import org.apache.inlong.audit.tool.entity.AuditMetric;
import org.apache.inlong.audit.tool.manager.AuditAlertRuleManager;
import org.apache.inlong.audit.tool.reporter.PrometheusReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertEvaluator {
    private final PrometheusReporter prometheusReporter;
    private static final Logger LOGGER = LoggerFactory.getLogger(AlertEvaluator.class);
    private final AuditAlertRuleManager auditAlertRuleManager;

    public AlertEvaluator(PrometheusReporter prometheusReporter, AuditAlertRuleManager auditAlertRuleManager) {
        this.prometheusReporter = prometheusReporter;
        this.auditAlertRuleManager = auditAlertRuleManager;
    }

    public void evaluateAndReportAlert(List<AuditMetric> sourceMetrics, List<AuditMetric> sinkMetrics, AuditAlertRule alertRule) {
        if (sourceMetrics == null || sinkMetrics == null) {
            return;
        }
        AuditAlertCondition condition = alertRule.getCondition();
        double threshold = condition.getValue();
        String op = condition.getOperator();
        for (AuditMetric source : sourceMetrics) {
            if (!Objects.equals(source.getInlongGroupId(), alertRule.getInlongGroupId()) || !Objects.equals(source.getInlongStreamId(), alertRule.getInlongStreamId())) continue;
            for (AuditMetric sink : sinkMetrics) {
                boolean hit;
                if (!Objects.equals(source.getInlongGroupId(), sink.getInlongGroupId()) || !Objects.equals(source.getInlongStreamId(), sink.getInlongStreamId()) || source.getCount() == 0L) continue;
                double diff = (double)(sink.getCount() - source.getCount()) / (double)source.getCount();
                switch (op) {
                    case ">": {
                        hit = diff > threshold;
                        break;
                    }
                    case ">=": {
                        hit = diff >= threshold;
                        break;
                    }
                    case "<": {
                        hit = diff < threshold;
                        break;
                    }
                    case "<=": {
                        hit = diff <= threshold;
                        break;
                    }
                    case "==": {
                        hit = diff == threshold;
                        break;
                    }
                    case "!=": {
                        hit = diff != threshold;
                        break;
                    }
                    default: {
                        hit = false;
                    }
                }
                if (!hit) continue;
                LOGGER.error("[ALERT] groupId={}, streamId={} | sourceCount={}, sinkCount={} | diff={} operator={} threshold={}", new Object[]{source.getInlongGroupId(), source.getInlongStreamId(), source.getCount(), sink.getCount(), diff, op, threshold});
                if (this.prometheusReporter.getAuditMetric() == null) continue;
                this.prometheusReporter.getAuditMetric().updateSourceAndSinkAuditDiffMetric(diff);
            }
        }
    }

    public AuditAlertRuleManager getAuditAlertRuleManager() {
        return this.auditAlertRuleManager;
    }
}

