/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.tool;

import java.util.Properties;
import org.apache.inlong.audit.tool.config.AppConfig;
import org.apache.inlong.audit.tool.evaluator.AlertEvaluator;
import org.apache.inlong.audit.tool.manager.AuditAlertRuleManager;
import org.apache.inlong.audit.tool.reporter.PrometheusReporter;
import org.apache.inlong.audit.tool.task.AuditCheckTask;
import org.apache.inlong.audit.tool.util.AuditSQLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditToolMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditToolMain.class);

    public static void main(String[] args) {
        AppConfig appConfig = new AppConfig();
        AuditAlertRuleManager auditAlertRuleManager = AuditAlertRuleManager.getInstance();
        auditAlertRuleManager.init(appConfig);
        auditAlertRuleManager.schedule();
        PrometheusReporter prometheusReporter = new PrometheusReporter();
        prometheusReporter.init(appConfig.getPrometheusConfig());
        AuditSQLUtil.initialize((Properties)appConfig.getProperties());
        AlertEvaluator alertEvaluator = new AlertEvaluator(prometheusReporter, auditAlertRuleManager);
        AuditCheckTask auditCheckTask = new AuditCheckTask(auditAlertRuleManager, alertEvaluator, appConfig);
        auditCheckTask.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            auditCheckTask.stop();
            LOGGER.error("Audit Tool stopped.");
        }));
        LOGGER.info("Audit Tool started.");
    }
}

