/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.store.metric.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.inlong.audit.file.ConfigManager;
import org.apache.inlong.audit.metric.AbstractMetric;
import org.apache.inlong.audit.store.metric.MetricDimension;
import org.apache.inlong.audit.store.metric.MetricItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorePrometheusMetric
extends Collector
implements AbstractMetric {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorePrometheusMetric.class);
    private static final String HELP_DESCRIPTION = "help";
    private final MetricItem metricItem;
    private HTTPServer server;

    public StorePrometheusMetric(MetricItem metricItem) {
        this.metricItem = metricItem;
        try {
            this.server = new HTTPServer(ConfigManager.getInstance().getValue("audit.store.prometheus.port", 10083));
            this.register();
        }
        catch (IOException e) {
            LOGGER.error("Construct store prometheus metric has IOException", (Throwable)e);
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        List<Collector.MetricFamilySamples.Sample> samples = Arrays.asList(this.createSample(MetricDimension.RECEIVE_COUNT_SUCCESS, this.metricItem.getReceiveCountSuccess().doubleValue()), this.createSample(MetricDimension.RECEIVE_FAILED, this.metricItem.getReceiveFailed().doubleValue()), this.createSample(MetricDimension.SEND_COUNT_SUCCESS, this.metricItem.getSendCountSuccess().doubleValue()), this.createSample(MetricDimension.SEND_COUNT_FAILED, this.metricItem.getSendCountFailed().doubleValue()), this.createSample(MetricDimension.SEND_DURATION, this.metricItem.getSendDuration().doubleValue()), this.createSample(MetricDimension.INVALID_DATA, this.metricItem.getInvalidData().doubleValue()));
        Collector.MetricFamilySamples metricFamilySamples = new Collector.MetricFamilySamples("audit-store", Collector.Type.GAUGE, HELP_DESCRIPTION, samples);
        return Collections.singletonList(metricFamilySamples);
    }

    private Collector.MetricFamilySamples.Sample createSample(MetricDimension key, double value) {
        return new Collector.MetricFamilySamples.Sample("audit-store", Collections.singletonList("dimensionName"), Collections.singletonList(key.getKey()), value);
    }

    public void report() {
        if (this.metricItem != null) {
            LOGGER.info("Report store Prometheus metric: {}", (Object)this.metricItem);
        } else {
            LOGGER.warn("MetricItem is null, nothing to report.");
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.close();
        }
    }
}

