/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.source;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.apache.inlong.audit.protocol.AuditApi;
import org.apache.inlong.audit.source.ServiceDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceDecoder
implements ServiceDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceDecoder.class);

    @Override
    public AuditApi.BaseCommand extractData(ByteBuf cb, Channel channel) throws Exception {
        if (null == cb) {
            LOG.error("cb == null");
            return null;
        }
        int totalLen = cb.readableBytes();
        if (0x1400000 < totalLen) {
            throw new Exception(new Throwable("err msg, ConfigConstants.MSG_MAX_LENGTH_BYTES < totalLen, and  totalLen=" + totalLen));
        }
        cb.markReaderIndex();
        AuditApi.BaseCommand cmd = null;
        AuditApi.BaseCommand.Builder cmdBuilder = AuditApi.BaseCommand.newBuilder();
        int cmdSize = cb.readInt();
        if (cmdSize <= totalLen) {
            byte[] bodyBytes = new byte[cmdSize];
            cb.readBytes(bodyBytes);
            LOG.debug("msg totalDataLen = {}, cmdSize = {}", (Object)totalLen, (Object)cmdSize);
            cmd = ((AuditApi.BaseCommand.Builder)cmdBuilder.mergeFrom(bodyBytes)).build();
        } else {
            cb.resetReaderIndex();
        }
        return cmd;
    }
}

