/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.snapshot;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import org.apache.inlong.agent.plugin.sources.snapshot.SnapshotBase;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnapshot
implements SnapshotBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotBase.class);
    protected static final Base64.Decoder DECODER = Base64.getDecoder();
    protected static final Base64.Encoder ENCODER = Base64.getEncoder();
    private static final int BUFFER_SIZE = 8192;
    private static final int START_OFFSET = 0;

    public byte[] load(File file) {
        try {
            int len;
            if (!file.exists()) {
                File parentDir = file.getParentFile();
                if (parentDir == null) {
                    LOGGER.info("no parent dir, file:{}", (Object)file.getAbsolutePath());
                    return new byte[0];
                }
                if (!parentDir.exists()) {
                    boolean success = parentDir.mkdirs();
                    LOGGER.info("create dir {} result {}", (Object)parentDir, (Object)success);
                }
                file.createNewFile();
            }
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream inputStream = new BufferedInputStream(fis);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
            inputStream.close();
            outputStream.close();
            return outputStream.toByteArray();
        }
        catch (Throwable ex) {
            LOGGER.error("load binlog offset error", ex);
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
            return null;
        }
    }

    public void save(String snapshot, File destFile) {
        byte[] bytes = DECODER.decode(snapshot);
        if (bytes.length != 0) {
            try (OutputStream output = Files.newOutputStream(destFile.toPath(), new OpenOption[0]);){
                output.write(bytes);
            }
            catch (Throwable e) {
                LOGGER.error("save offset to file error", e);
                ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)e);
            }
        }
    }
}

