/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.OffsetProfile;
import org.apache.inlong.agent.core.FileStaticManager;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.except.FileException;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.sources.extend.DefaultExtendedHandler;
import org.apache.inlong.agent.plugin.sources.file.AbstractSource;
import org.apache.inlong.agent.plugin.task.logcollection.local.FileDataUtils;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileSource
extends AbstractSource {
    public static final int LEN_OF_FILE_OFFSET_ARRAY = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogFileSource.class);
    public static final String OFFSET_SEP = ":";
    private final Integer SIZE_OF_BUFFER_TO_READ_FILE = 65536;
    private final Long INODE_UPDATE_INTERVAL_MS = 1000L;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String fileName;
    private File file;
    private byte[] bufferToReadFile;
    public volatile long linePosition = 0L;
    public volatile long bytePosition = 0L;
    private boolean isIncrement = false;
    private volatile boolean fileExist = true;
    private String inodeInfo;
    private volatile long lastInodeUpdateTime = 0L;
    private RandomAccessFile randomAccessFile;

    @Override
    protected void initExtendClass() {
        this.extendClass = DefaultExtendedHandler.class.getCanonicalName();
    }

    @Override
    protected void initSource(InstanceProfile profile) {
        try {
            LOGGER.info("LogFileSource init: {}", (Object)profile.toJsonStr());
            this.fileName = profile.getInstanceId();
            this.bufferToReadFile = new byte[this.SIZE_OF_BUFFER_TO_READ_FILE.intValue()];
            this.isIncrement = this.isIncrement(profile);
            this.file = new File(this.fileName);
            this.inodeInfo = profile.get("inodeInfo");
            this.lastInodeUpdateTime = AgentUtils.getCurrentTime();
            this.initOffset(this.isIncrement, this.taskId, this.instanceId, this.inodeInfo);
            this.randomAccessFile = new RandomAccessFile(this.file, "r");
        }
        catch (Exception ex) {
            this.stopRunning();
            throw new FileException("error init stream for " + this.file.getPath(), (Throwable)ex);
        }
    }

    @Override
    protected boolean doPrepareToRead() {
        if (this.isInodeChanged()) {
            this.fileExist = false;
            LOGGER.info("inode changed, instance will restart and offset will be clean, file {}", (Object)this.fileName);
            return false;
        }
        if (this.file.length() < this.bytePosition) {
            this.fileExist = false;
            LOGGER.info("file rotate, instance will restart and offset will be clean, file {}", (Object)this.fileName);
            return false;
        }
        return true;
    }

    @Override
    protected List<AbstractSource.SourceData> readFromSource() {
        try {
            return this.readFromPos(this.bytePosition);
        }
        catch (FileNotFoundException e) {
            this.fileExist = false;
            LOGGER.error("readFromPos file deleted error: ", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("readFromPos error: ", (Throwable)e);
        }
        return null;
    }

    @Override
    protected void printCurrentState() {
        LOGGER.info("path is {}, linePosition {}, bytePosition is {} file len {}", new Object[]{this.file.getName(), this.linePosition, this.bytePosition, this.file.length()});
    }

    @Override
    protected String getThreadName() {
        return "log-file-source-" + this.taskId + "-" + this.fileName;
    }

    private List<AbstractSource.SourceData> readFromPos(long pos) throws IOException {
        ArrayList<AbstractSource.SourceData> lines = new ArrayList<AbstractSource.SourceData>();
        this.bytePosition = this.readLines(this.randomAccessFile, pos, lines, this.BATCH_READ_LINE_COUNT, this.BATCH_READ_LINE_TOTAL_LEN);
        return lines;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getRealLineCount(String fileName) {
        try (LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.instanceId));){
            lineNumberReader.skip(Long.MAX_VALUE);
            int n = lineNumberReader.getLineNumber();
            return n;
        }
        catch (IOException ex) {
            LOGGER.error("getRealLineCount error {} file {}", (Object)ex.getMessage(), (Object)fileName);
            return 0;
        }
    }

    private void initOffset(boolean isIncrement, String taskId, String instanceId, String inodeInfo) throws IOException {
        long byteOffset;
        long lineOffset;
        if (this.offsetProfile != null && this.offsetProfile.getInodeInfo().compareTo(inodeInfo) == 0) {
            FileOffset fileOffset = this.parseFIleOffset(this.offsetProfile.getOffset());
            if (fileOffset.hasByteOffset) {
                lineOffset = fileOffset.lineOffset;
                byteOffset = fileOffset.byteOffset;
                LOGGER.info("initOffset inode no change taskId {} restore lineOffset {} byteOffset {}, file {}", new Object[]{taskId, lineOffset, byteOffset, this.fileName});
            } else {
                lineOffset = fileOffset.lineOffset;
                byteOffset = this.getBytePositionByLine(lineOffset);
                LOGGER.info("initOffset inode no change taskId {} restore lineOffset {} count byteOffset {}, file {}", new Object[]{taskId, lineOffset, byteOffset, this.fileName});
            }
        } else if (isIncrement) {
            lineOffset = this.getRealLineCount(instanceId);
            byteOffset = this.getBytePositionByLine(lineOffset);
            LOGGER.info("initOffset taskId {} for new increment lineOffset {} byteOffset {}, file {}", new Object[]{taskId, lineOffset, byteOffset, this.fileName});
        } else {
            lineOffset = 0L;
            byteOffset = 0L;
            LOGGER.info("initOffset taskId {} for new all read lineOffset {} byteOffset {} file {}", new Object[]{taskId, lineOffset, byteOffset, this.fileName});
        }
        this.linePosition = lineOffset;
        this.bytePosition = byteOffset;
    }

    public File getFile() {
        return this.file;
    }

    private boolean isIncrement(InstanceProfile profile) {
        return profile.hasKey("task.fileTask.contentCollectType") && "INCREMENT".equalsIgnoreCase(profile.get("task.fileTask.contentCollectType"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getBytePositionByLine(long linePosition) throws IOException {
        long pos = 0L;
        try (RandomAccessFile input = null;){
            ArrayList<AbstractSource.SourceData> lines;
            input = new RandomAccessFile(this.file, "r");
            for (long readCount = 0L; readCount < linePosition; readCount += (long)lines.size()) {
                lines = new ArrayList<AbstractSource.SourceData>();
                pos = this.readLines(input, pos, lines, Math.min((int)(linePosition - readCount), this.BATCH_READ_LINE_COUNT), this.BATCH_READ_LINE_TOTAL_LEN);
                if (lines.size() != 0) continue;
                LOGGER.error("getBytePositionByLine LineNum {} larger than the real file");
                break;
            }
        }
        LOGGER.info("getBytePositionByLine {} LineNum {} position {}", new Object[]{this.fileName, linePosition, pos});
        return pos;
    }

    private long readLines(RandomAccessFile reader, long pos, List<AbstractSource.SourceData> lines, int maxLineCount, int maxLineTotalLen) throws IOException {
        int num;
        if (maxLineCount == 0) {
            return pos;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        reader.seek(pos);
        long rePos = pos;
        int lineTotalLen = 0;
        boolean overLen = false;
        while ((num = reader.read(this.bufferToReadFile)) != -1) {
            int i;
            LOGGER.debug("read size {}", (Object)num);
            for (i = 0; i < num; ++i) {
                byte ch = this.bufferToReadFile[i];
                switch (ch) {
                    case 10: {
                        ++this.linePosition;
                        rePos = pos + (long)i + 1L;
                        lines.add(new AbstractSource.SourceData(this, baos.toByteArray(), this.getOffsetString(this.linePosition, rePos)));
                        lineTotalLen += baos.size();
                        if (overLen) {
                            LOGGER.warn("readLines over len finally string len {}", (Object)new String(baos.toByteArray()).length());
                            long auditTime = 0L;
                            auditTime = this.isRealTime ? AgentUtils.getCurrentTime() : this.profile.getSinkDataTime();
                            AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_READ_FAILED, (String)this.inlongGroupId, (String)this.inlongStreamId, (long)auditTime, (int)1, (long)this.maxPackSize, (long)this.auditVersion);
                            AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_READ_FAILED_REAL_TIME, (String)this.inlongGroupId, (String)this.inlongStreamId, (long)AgentUtils.getCurrentTime(), (int)1, (long)this.maxPackSize, (long)this.auditVersion);
                        }
                        baos.reset();
                        overLen = false;
                        break;
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        if (baos.size() < this.maxPackSize) {
                            baos.write(ch);
                            break;
                        }
                        overLen = true;
                    }
                }
                if (lines.size() >= maxLineCount || lineTotalLen >= maxLineTotalLen) break;
            }
            if (lines.size() >= maxLineCount || lineTotalLen >= maxLineTotalLen) break;
            if (i != num) continue;
            pos = reader.getFilePointer();
        }
        baos.close();
        reader.seek(rePos);
        return rePos;
    }

    private String getOffsetString(Long lineOffset, Long byteOffset) {
        return lineOffset + OFFSET_SEP + byteOffset;
    }

    private FileOffset parseFIleOffset(String offset) {
        String[] offsetArray = offset.split(OFFSET_SEP);
        if (offsetArray.length == 2) {
            return new FileOffset(Long.parseLong(offsetArray[0]), Long.parseLong(offsetArray[1]), true);
        }
        return new FileOffset(Long.parseLong(offsetArray[0]), null, false);
    }

    private boolean isInodeChanged() {
        if (AgentUtils.getCurrentTime() - this.lastInodeUpdateTime > this.INODE_UPDATE_INTERVAL_MS) {
            try {
                return FileDataUtils.getInodeInfo(this.fileName).compareTo(this.inodeInfo) != 0;
            }
            catch (IOException e) {
                LOGGER.error("check inode change file {} error", (Object)this.fileName, (Object)e);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isRunnable() {
        return this.runnable && this.fileExist;
    }

    public boolean sourceExist() {
        return this.fileExist;
    }

    @Override
    protected void releaseSource() {
        if (this.randomAccessFile != null) {
            try {
                FileStaticManager.FileStatic data = new FileStaticManager.FileStatic();
                data.setTaskId(this.taskId);
                data.setRetry(String.valueOf(this.profile.isRetry()));
                data.setContentType(this.profile.get("task.fileTask.dataContentStyle"));
                data.setGroupId(this.profile.getInlongGroupId());
                data.setStreamId(this.profile.getInlongStreamId());
                data.setDataTime(this.format.format(this.profile.getSinkDataTime()));
                data.setFileName(this.profile.getInstanceId());
                data.setFileLen(String.valueOf(this.randomAccessFile.length()));
                data.setReadBytes(String.valueOf(this.bytePosition));
                data.setReadLines(String.valueOf(this.linePosition));
                OffsetProfile offsetProfile = OffsetManager.getInstance().getOffset(this.taskId, this.instanceId);
                if (offsetProfile != null) {
                    data.setSendLines(offsetProfile.getOffset());
                }
                FileStaticManager.putStaticMsg((FileStaticManager.FileStatic)data);
                this.randomAccessFile.close();
            }
            catch (IOException e) {
                LOGGER.error("close randomAccessFile error", (Throwable)e);
            }
        }
    }

    @Override
    public long getLastModifyTime() {
        return FileUtils.getFileLastModifyTime((String)this.fileName);
    }

    protected class FileOffset {
        private Long lineOffset;
        private Long byteOffset;
        private boolean hasByteOffset;

        public Long getLineOffset() {
            return this.lineOffset;
        }

        public Long getByteOffset() {
            return this.byteOffset;
        }

        public boolean isHasByteOffset() {
            return this.hasByteOffset;
        }

        public void setLineOffset(Long lineOffset) {
            this.lineOffset = lineOffset;
        }

        public void setByteOffset(Long byteOffset) {
            this.byteOffset = byteOffset;
        }

        public void setHasByteOffset(boolean hasByteOffset) {
            this.hasByteOffset = hasByteOffset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileOffset)) {
                return false;
            }
            FileOffset other = (FileOffset)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHasByteOffset() != other.isHasByteOffset()) {
                return false;
            }
            Long this$lineOffset = this.getLineOffset();
            Long other$lineOffset = other.getLineOffset();
            if (this$lineOffset == null ? other$lineOffset != null : !((Object)this$lineOffset).equals(other$lineOffset)) {
                return false;
            }
            Long this$byteOffset = this.getByteOffset();
            Long other$byteOffset = other.getByteOffset();
            return !(this$byteOffset == null ? other$byteOffset != null : !((Object)this$byteOffset).equals(other$byteOffset));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileOffset;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasByteOffset() ? 79 : 97);
            Long $lineOffset = this.getLineOffset();
            result = result * 59 + ($lineOffset == null ? 43 : ((Object)$lineOffset).hashCode());
            Long $byteOffset = this.getByteOffset();
            result = result * 59 + ($byteOffset == null ? 43 : ((Object)$byteOffset).hashCode());
            return result;
        }

        public String toString() {
            return "LogFileSource.FileOffset(lineOffset=" + this.getLineOffset() + ", byteOffset=" + this.getByteOffset() + ", hasByteOffset=" + this.isHasByteOffset() + ")";
        }

        public FileOffset(Long lineOffset, Long byteOffset, boolean hasByteOffset) {
            this.lineOffset = lineOffset;
            this.byteOffset = byteOffset;
            this.hasByteOffset = hasByteOffset;
        }

        public FileOffset() {
        }
    }
}

