/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils.file;

import com.google.common.base.Predicate;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class FileFinderIterator
implements Iterator<File> {
    private final Predicate<File> yieldFilter;
    private final Predicate<File> branchFilter;
    private final Predicate<File> fileFilter;
    private final Predicate<File> dirFilter;
    private LinkedList<DepthControl> depthStack = new LinkedList();
    private Queue<File> resultQueue = new LinkedList<File>();
    private int maxDepth = 1;

    public FileFinderIterator(File baseDir, Predicate<File> yieldFilter, Predicate<File> branchFilter, Predicate<File> fileFilter, Predicate<File> dirFilter, int maxDepth) {
        this.yieldFilter = yieldFilter;
        this.branchFilter = branchFilter;
        this.fileFilter = fileFilter;
        this.maxDepth = maxDepth;
        this.dirFilter = dirFilter;
        File[] listFiles = baseDir.listFiles();
        if (listFiles != null) {
            for (File f : listFiles) {
                this.depthStack.add(new DepthControl(1, f));
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.resultQueue.isEmpty()) {
            this.populateResults();
        }
        return !this.resultQueue.isEmpty();
    }

    @Override
    public File next() {
        if (this.resultQueue.isEmpty()) {
            this.populateResults();
        }
        return this.resultQueue.poll();
    }

    private void populateResults() {
        while (!this.depthStack.isEmpty() && this.resultQueue.isEmpty()) {
            DepthControl currentDepthControl = this.depthStack.pop();
            File currentFile = currentDepthControl.getFile();
            int currentDepth = currentDepthControl.getDepth();
            if (!this.yieldFilter.apply((Object)currentFile)) continue;
            if (currentFile.isDirectory() && this.dirFilter.apply((Object)currentFile)) {
                File[] subFiles;
                if (!this.branchFilter.apply((Object)currentFile) || currentDepth >= this.maxDepth || (subFiles = currentFile.listFiles()) == null) continue;
                for (File f : subFiles) {
                    this.depthStack.add(new DepthControl(currentDepth + 1, f));
                }
                continue;
            }
            if (!currentFile.isFile() || !this.fileFilter.apply((Object)currentFile)) continue;
            this.resultQueue.offer(currentFile);
        }
    }

    @Override
    public void remove() {
    }

    public class DepthControl {
        private int depth;
        private File file;

        public DepthControl(int depth, File file) {
            this.depth = depth;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public int getDepth() {
            return this.depth;
        }
    }
}

