/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.store;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.agent.conf.OffsetProfile;
import org.apache.inlong.agent.store.KeyValueEntity;
import org.apache.inlong.agent.store.Store;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffsetStore.class);
    private final Store store;

    public OffsetStore(Store store) {
        this.store = store;
    }

    public List<OffsetProfile> listAllOffsets() {
        List<KeyValueEntity> result = this.store.findAll(this.store.getUniqueKey());
        ArrayList<OffsetProfile> offsetList = new ArrayList<OffsetProfile>();
        for (KeyValueEntity entity : result) {
            offsetList.add(entity.getAsOffsetProfile());
        }
        return offsetList;
    }

    public OffsetProfile getOffset(String taskId, String instanceId) {
        KeyValueEntity result = this.store.get(this.getKey(taskId, instanceId));
        if (result == null) {
            return null;
        }
        return result.getAsOffsetProfile();
    }

    public void deleteOffset(String taskId, String instanceId) {
        this.store.remove(this.getKey(taskId, instanceId));
    }

    public void setOffset(OffsetProfile offsetProfile) {
        offsetProfile.setLastUpdateTime(AgentUtils.getCurrentTime());
        if (offsetProfile.allRequiredKeyExist()) {
            String keyName = this.getKey(offsetProfile.getTaskId(), offsetProfile.getInstanceId());
            KeyValueEntity entity = new KeyValueEntity(keyName, offsetProfile.toJsonStr(), offsetProfile.get("instance.id"));
            this.store.put(entity);
        }
    }

    public String getKey(String taskId, String instanceId) {
        if (this.store.getUniqueKey().isEmpty()) {
            return "offset" + this.store.getSplitter() + taskId + this.store.getSplitter() + this.store.replaceKeywords(instanceId);
        }
        return this.store.getUniqueKey() + this.store.getSplitter() + "offset" + this.store.getSplitter() + taskId + this.store.getSplitter() + this.store.replaceKeywords(instanceId);
    }
}

