/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.security.authentication.event;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.security.authentication.basic.BasicAuthenticationProviderConfiguration;
import org.apache.ignite.internal.security.authentication.configuration.AuthenticationProviderConfiguration;
import org.apache.ignite.internal.security.authentication.configuration.AuthenticationProviderView;
import org.apache.ignite.internal.security.authentication.event.AuthenticationEventParameters;
import org.apache.ignite.internal.security.authentication.event.AuthenticationProviderEventParameters;
import org.apache.ignite.internal.security.authentication.event.UserEventFactory;
import org.apache.ignite.internal.security.configuration.SecurityConfiguration;
import org.apache.ignite.internal.util.CompletableFutures;

public class AuthenticationProviderEventFactory
implements ConfigurationNamedListListener<AuthenticationProviderView> {
    private final SecurityConfiguration securityConfiguration;
    private final UserEventFactory userEventFactory;
    private final Function<AuthenticationEventParameters, CompletableFuture<Void>> notifier;

    public AuthenticationProviderEventFactory(SecurityConfiguration securityConfiguration, UserEventFactory userEventFactory, Function<AuthenticationEventParameters, CompletableFuture<Void>> notifier) {
        this.securityConfiguration = securityConfiguration;
        this.userEventFactory = userEventFactory;
        this.notifier = notifier;
    }

    public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<AuthenticationProviderView> ctx) {
        this.onCreate((AuthenticationProviderView)ctx.newValue());
        return CompletableFutures.nullCompletedFuture();
    }

    private void onCreate(AuthenticationProviderView providerView) {
        AuthenticationProviderConfiguration configuration;
        if ("basic".equals(providerView.type()) && (configuration = (AuthenticationProviderConfiguration)this.securityConfiguration.authentication().providers().get(providerView.name())) != null) {
            BasicAuthenticationProviderConfiguration basicCfg = (BasicAuthenticationProviderConfiguration)configuration;
            basicCfg.users().listenElements((ConfigurationNamedListListener)this.userEventFactory);
        }
    }

    public CompletableFuture<?> onRename(ConfigurationNotificationEvent<AuthenticationProviderView> ctx) {
        this.onCreate((AuthenticationProviderView)ctx.newValue());
        return this.notifier.apply((AuthenticationEventParameters)AuthenticationProviderEventParameters.removed((String)((AuthenticationProviderView)ctx.oldValue()).name()));
    }

    public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<AuthenticationProviderView> ctx) {
        return this.notifier.apply((AuthenticationEventParameters)AuthenticationProviderEventParameters.removed((String)((AuthenticationProviderView)ctx.oldValue()).name()));
    }

    public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<AuthenticationProviderView> ctx) {
        if ("basic".equals(((AuthenticationProviderView)ctx.oldValue()).type()) && ((AuthenticationProviderView)ctx.oldValue()).type().equals(((AuthenticationProviderView)ctx.newValue()).type())) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.notifier.apply((AuthenticationEventParameters)AuthenticationProviderEventParameters.updated((String)((AuthenticationProviderView)ctx.newValue()).name()));
    }
}

