/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.command.TimedBinaryRowMessage;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllCommand;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllCommandBuilder;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllCommandSerializer;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class UpdateAllCommandImpl
implements UpdateAllCommand,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 42;
    @IgniteToStringInclude
    private final boolean full;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private final Long leaseStartTime;
    @IgniteToStringInclude
    private final Map<UUID, TimedBinaryRowMessage> messageRowsToUpdate;
    @IgniteToStringInclude
    private int requiredCatalogVersion;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;
    @IgniteToStringInclude
    private final TablePartitionIdMessage tablePartitionId;
    @IgniteToStringInclude
    private final UUID txCoordinatorId;
    @IgniteToStringInclude
    private final UUID txId;

    private UpdateAllCommandImpl(boolean full, HybridTimestamp initiatorTime, Long leaseStartTime, Map<UUID, TimedBinaryRowMessage> messageRowsToUpdate, int requiredCatalogVersion, HybridTimestamp safeTime, TablePartitionIdMessage tablePartitionId, UUID txCoordinatorId, UUID txId) {
        this.full = full;
        this.initiatorTime = initiatorTime;
        this.leaseStartTime = leaseStartTime;
        this.messageRowsToUpdate = messageRowsToUpdate;
        this.requiredCatalogVersion = requiredCatalogVersion;
        this.safeTime = safeTime;
        this.tablePartitionId = tablePartitionId;
        this.txCoordinatorId = txCoordinatorId;
        this.txId = txId;
    }

    @Override
    public boolean full() {
        return this.full;
    }

    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public Long leaseStartTime() {
        return this.leaseStartTime;
    }

    @Override
    public Map<UUID, TimedBinaryRowMessage> messageRowsToUpdate() {
        return this.messageRowsToUpdate;
    }

    @Override
    public void requiredCatalogVersion(int requiredCatalogVersion) {
        this.requiredCatalogVersion = requiredCatalogVersion;
    }

    @Override
    public int requiredCatalogVersion() {
        return this.requiredCatalogVersion;
    }

    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    @Override
    public TablePartitionIdMessage tablePartitionId() {
        return this.tablePartitionId;
    }

    @Override
    public UUID txCoordinatorId() {
        return this.txCoordinatorId;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return UpdateAllCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(UpdateAllCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 42;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UpdateAllCommandImpl otherMessage = (UpdateAllCommandImpl)other;
        return Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.leaseStartTime, otherMessage.leaseStartTime) && Objects.equals(this.messageRowsToUpdate, otherMessage.messageRowsToUpdate) && Objects.equals(this.safeTime, otherMessage.safeTime) && Objects.equals(this.tablePartitionId, otherMessage.tablePartitionId) && Objects.equals(this.txCoordinatorId, otherMessage.txCoordinatorId) && Objects.equals(this.txId, otherMessage.txId) && this.full == otherMessage.full && this.requiredCatalogVersion == otherMessage.requiredCatalogVersion;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.full, this.requiredCatalogVersion, this.initiatorTime, this.leaseStartTime, this.messageRowsToUpdate, this.safeTime, this.tablePartitionId, this.txCoordinatorId, this.txId);
        return result;
    }

    public UpdateAllCommandImpl clone() {
        try {
            return (UpdateAllCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static UpdateAllCommandBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.messageRowsToUpdate != null) {
            Set<Map.Entry<UUID, TimedBinaryRowMessage>> messageRowsToUpdateEntrySet = this.messageRowsToUpdate.entrySet();
            for (Map.Entry<UUID, TimedBinaryRowMessage> entry : messageRowsToUpdateEntrySet) {
                UUID key = entry.getKey();
                TimedBinaryRowMessage value = entry.getValue();
                if (value == null) continue;
                value.prepareMarshal(usedDescriptors, marshaller);
            }
        }
        if (this.tablePartitionId != null) {
            this.tablePartitionId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.messageRowsToUpdate != null) {
            Set<Map.Entry<UUID, TimedBinaryRowMessage>> messageRowsToUpdateEntrySet = this.messageRowsToUpdate.entrySet();
            for (Map.Entry<UUID, TimedBinaryRowMessage> entry : messageRowsToUpdateEntrySet) {
                UUID key = entry.getKey();
                TimedBinaryRowMessage value = entry.getValue();
                if (value == null) continue;
                value.unmarshal(marshaller, descriptorsObj);
            }
        }
        if (this.tablePartitionId != null) {
            this.tablePartitionId.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements UpdateAllCommandBuilder {
        private boolean full;
        private HybridTimestamp initiatorTime;
        private Long leaseStartTime;
        private Map<UUID, TimedBinaryRowMessage> messageRowsToUpdate;
        private int requiredCatalogVersion;
        private HybridTimestamp safeTime;
        private TablePartitionIdMessage tablePartitionId;
        private UUID txCoordinatorId;
        private UUID txId;

        private Builder() {
        }

        @Override
        public UpdateAllCommandBuilder full(boolean full) {
            this.full = full;
            return this;
        }

        @Override
        public UpdateAllCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public UpdateAllCommandBuilder leaseStartTime(Long leaseStartTime) {
            this.leaseStartTime = leaseStartTime;
            return this;
        }

        @Override
        public UpdateAllCommandBuilder messageRowsToUpdate(Map<UUID, TimedBinaryRowMessage> messageRowsToUpdate) {
            Objects.requireNonNull(messageRowsToUpdate, "messageRowsToUpdate is not marked @Nullable");
            this.messageRowsToUpdate = messageRowsToUpdate;
            return this;
        }

        @Override
        public UpdateAllCommandBuilder requiredCatalogVersion(int requiredCatalogVersion) {
            this.requiredCatalogVersion = requiredCatalogVersion;
            return this;
        }

        @Override
        public UpdateAllCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public UpdateAllCommandBuilder tablePartitionId(TablePartitionIdMessage tablePartitionId) {
            Objects.requireNonNull(tablePartitionId, "tablePartitionId is not marked @Nullable");
            this.tablePartitionId = tablePartitionId;
            return this;
        }

        @Override
        public UpdateAllCommandBuilder txCoordinatorId(UUID txCoordinatorId) {
            Objects.requireNonNull(txCoordinatorId, "txCoordinatorId is not marked @Nullable");
            this.txCoordinatorId = txCoordinatorId;
            return this;
        }

        @Override
        public UpdateAllCommandBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public boolean full() {
            return this.full;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public Long leaseStartTime() {
            return this.leaseStartTime;
        }

        @Override
        public Map<UUID, TimedBinaryRowMessage> messageRowsToUpdate() {
            return this.messageRowsToUpdate;
        }

        @Override
        public int requiredCatalogVersion() {
            return this.requiredCatalogVersion;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public TablePartitionIdMessage tablePartitionId() {
            return this.tablePartitionId;
        }

        @Override
        public UUID txCoordinatorId() {
            return this.txCoordinatorId;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public UpdateAllCommand build() {
            return new UpdateAllCommandImpl(this.full, Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), this.leaseStartTime, Objects.requireNonNull(this.messageRowsToUpdate, "messageRowsToUpdate is not marked @Nullable"), this.requiredCatalogVersion, this.safeTime, Objects.requireNonNull(this.tablePartitionId, "tablePartitionId is not marked @Nullable"), Objects.requireNonNull(this.txCoordinatorId, "txCoordinatorId is not marked @Nullable"), Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }
    }
}

