/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.ApplyNameMapping;
import org.apache.iceberg.parquet.MessageTypeToType;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.parquet.PruneColumns;
import org.apache.iceberg.parquet.TypeToMessageType;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;

public class ParquetSchemaUtil {
    private ParquetSchemaUtil() {
    }

    public static MessageType convert(Schema schema, String name) {
        return new TypeToMessageType().convert(schema, name);
    }

    public static Schema convert(MessageType parquetSchema) {
        MessageType parquetSchemaWithIds = ParquetSchemaUtil.hasIds(parquetSchema) ? parquetSchema : ParquetSchemaUtil.addFallbackIds(parquetSchema);
        AtomicInteger nextId = new AtomicInteger(1000);
        return ParquetSchemaUtil.convertInternal(parquetSchemaWithIds, name -> nextId.getAndIncrement());
    }

    public static Schema convertAndPrune(MessageType parquetSchema) {
        return ParquetSchemaUtil.convertInternal(parquetSchema, name -> null);
    }

    private static Schema convertInternal(MessageType parquetSchema, Function<String[], Integer> nameToIdFunc) {
        MessageTypeToType converter = new MessageTypeToType(nameToIdFunc);
        return new Schema(ParquetTypeVisitor.visit((org.apache.parquet.schema.Type)parquetSchema, converter).asNestedType().fields(), converter.getAliases());
    }

    public static MessageType pruneColumns(MessageType fileSchema, Schema expectedSchema) {
        Set selectedIds = TypeUtil.getProjectedIds((Schema)expectedSchema);
        return (MessageType)TypeWithSchemaVisitor.visit((Type)expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileSchema, new PruneColumns(selectedIds));
    }

    public static MessageType pruneColumnsFallback(MessageType fileSchema, Schema expectedSchema) {
        HashSet selectedIds = Sets.newHashSet();
        for (Types.NestedField field : expectedSchema.columns()) {
            selectedIds.add(field.fieldId());
        }
        Types.MessageTypeBuilder builder = Types.buildMessage();
        int ordinal = 1;
        for (org.apache.parquet.schema.Type type : fileSchema.getFields()) {
            if (selectedIds.contains(ordinal)) {
                builder.addField(type.withId(ordinal));
            }
            ++ordinal;
        }
        return builder.named(fileSchema.getName());
    }

    public static boolean hasIds(MessageType fileSchema) {
        return ParquetTypeVisitor.visit((org.apache.parquet.schema.Type)fileSchema, new HasIds());
    }

    public static MessageType addFallbackIds(MessageType fileSchema) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        int ordinal = 1;
        for (org.apache.parquet.schema.Type type : fileSchema.getFields()) {
            builder.addField(type.withId(ordinal));
            ++ordinal;
        }
        return builder.named(fileSchema.getName());
    }

    public static MessageType applyNameMapping(MessageType fileSchema, NameMapping nameMapping) {
        return (MessageType)ParquetTypeVisitor.visit((org.apache.parquet.schema.Type)fileSchema, new ApplyNameMapping(nameMapping));
    }

    public static org.apache.parquet.schema.Type determineListElementType(GroupType array) {
        org.apache.parquet.schema.Type repeated = (org.apache.parquet.schema.Type)array.getFields().get(0);
        boolean isOldListElementType = ParquetSchemaUtil.isOldListElementType(array);
        return isOldListElementType ? repeated : repeated.asGroupType().getType(0);
    }

    static boolean isOldListElementType(GroupType list) {
        org.apache.parquet.schema.Type repeatedType = (org.apache.parquet.schema.Type)list.getFields().get(0);
        String parentName = list.getName();
        return repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1 || repeatedType.getName().equals("array") || repeatedType.getName().equals(parentName + "_tuple");
    }

    public static class HasIds
    extends ParquetTypeVisitor<Boolean> {
        @Override
        public Boolean message(MessageType message, List<Boolean> fields) {
            return this.struct((GroupType)message, (List)fields);
        }

        @Override
        public Boolean struct(GroupType struct, List<Boolean> hasIds) {
            for (Boolean hasId : hasIds) {
                if (!hasId.booleanValue()) continue;
                return true;
            }
            return struct.getId() != null;
        }

        @Override
        public Boolean list(GroupType array, Boolean hasId) {
            return hasId != false || array.getId() != null;
        }

        @Override
        public Boolean map(GroupType map, Boolean keyHasId, Boolean valueHasId) {
            return keyHasId != false || valueHasId != false || map.getId() != null;
        }

        @Override
        public Boolean primitive(PrimitiveType primitive) {
            return primitive.getId() != null;
        }
    }
}

