/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.orc.OrcValueReader;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.orc.storage.ql.exec.vector.StructColumnVector;

public class OrcValueReaders {
    private OrcValueReaders() {
    }

    public static OrcValueReader<Boolean> booleans() {
        return BooleanReader.INSTANCE;
    }

    public static OrcValueReader<Integer> ints() {
        return IntegerReader.INSTANCE;
    }

    public static OrcValueReader<Long> longs() {
        return LongReader.INSTANCE;
    }

    public static OrcValueReader<Float> floats() {
        return FloatReader.INSTANCE;
    }

    public static OrcValueReader<Double> doubles() {
        return DoubleReader.INSTANCE;
    }

    public static OrcValueReader<byte[]> bytes() {
        return BytesReader.INSTANCE;
    }

    public static abstract class StructReader<T>
    implements OrcValueReader<T> {
        private final OrcValueReader<?>[] readers;
        private final int[] positions;
        private final Object[] constants;

        protected StructReader(List<OrcValueReader<?>> readers) {
            this.readers = readers.toArray(new OrcValueReader[0]);
            this.positions = new int[0];
            this.constants = new Object[0];
        }

        protected StructReader(List<OrcValueReader<?>> readers, Types.StructType struct, Map<Integer, ?> idToConstant) {
            this.readers = readers.toArray(new OrcValueReader[0]);
            List fields = struct.fields();
            ArrayList positionList = Lists.newArrayListWithCapacity((int)fields.size());
            ArrayList constantList = Lists.newArrayListWithCapacity((int)fields.size());
            for (int pos = 0; pos < fields.size(); ++pos) {
                Types.NestedField field = (Types.NestedField)fields.get(pos);
                Object constant = idToConstant.get(field.fieldId());
                if (constant == null) continue;
                positionList.add(pos);
                constantList.add(idToConstant.get(field.fieldId()));
            }
            this.positions = positionList.stream().mapToInt(Integer::intValue).toArray();
            this.constants = constantList.toArray();
        }

        protected abstract T create();

        protected abstract void set(T var1, int var2, Object var3);

        public OrcValueReader<?> reader(int pos) {
            return this.readers[pos];
        }

        @Override
        public T nonNullRead(ColumnVector vector, int row) {
            StructColumnVector structVector = (StructColumnVector)vector;
            return this.readInternal(this.create(), structVector.fields, row);
        }

        private T readInternal(T struct, ColumnVector[] columnVectors, int row) {
            for (int c = 0; c < this.readers.length; ++c) {
                this.set(struct, c, this.reader(c).read(columnVectors[c], row));
            }
            for (int i = 0; i < this.positions.length; ++i) {
                this.set(struct, this.positions[i], this.constants[i]);
            }
            return struct;
        }
    }

    private static class BytesReader
    implements OrcValueReader<byte[]> {
        private static final BytesReader INSTANCE = new BytesReader();

        private BytesReader() {
        }

        @Override
        public byte[] nonNullRead(ColumnVector vector, int row) {
            BytesColumnVector bytesVector = (BytesColumnVector)vector;
            return Arrays.copyOfRange(bytesVector.vector[row], bytesVector.start[row], bytesVector.start[row] + bytesVector.length[row]);
        }
    }

    private static class DoubleReader
    implements OrcValueReader<Double> {
        private static final DoubleReader INSTANCE = new DoubleReader();

        private DoubleReader() {
        }

        @Override
        public Double nonNullRead(ColumnVector vector, int row) {
            return ((DoubleColumnVector)vector).vector[row];
        }
    }

    private static class FloatReader
    implements OrcValueReader<Float> {
        private static final FloatReader INSTANCE = new FloatReader();

        private FloatReader() {
        }

        @Override
        public Float nonNullRead(ColumnVector vector, int row) {
            return Float.valueOf((float)((DoubleColumnVector)vector).vector[row]);
        }
    }

    private static class LongReader
    implements OrcValueReader<Long> {
        static final LongReader INSTANCE = new LongReader();

        private LongReader() {
        }

        @Override
        public Long nonNullRead(ColumnVector vector, int row) {
            return ((LongColumnVector)vector).vector[row];
        }
    }

    private static class IntegerReader
    implements OrcValueReader<Integer> {
        static final IntegerReader INSTANCE = new IntegerReader();

        private IntegerReader() {
        }

        @Override
        public Integer nonNullRead(ColumnVector vector, int row) {
            return (int)((LongColumnVector)vector).vector[row];
        }
    }

    private static class BooleanReader
    implements OrcValueReader<Boolean> {
        static final BooleanReader INSTANCE = new BooleanReader();

        private BooleanReader() {
        }

        @Override
        public Boolean nonNullRead(ColumnVector vector, int row) {
            return ((LongColumnVector)vector).vector[row] != 0L;
        }
    }
}

