/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.orc.TypeDescription;

public abstract class OrcSchemaVisitor<T> {
    public static <T> List<T> visitSchema(TypeDescription schema, OrcSchemaVisitor<T> visitor) {
        Preconditions.checkArgument((schema.getId() == 0 ? 1 : 0) != 0, (Object)"TypeDescription must be root schema.");
        List fields = schema.getChildren();
        List names = schema.getFieldNames();
        return OrcSchemaVisitor.visitFields(fields, names, visitor);
    }

    public static <T> T visit(TypeDescription schema, OrcSchemaVisitor<T> visitor) {
        switch (schema.getCategory()) {
            case STRUCT: {
                return OrcSchemaVisitor.visitRecord(schema, visitor);
            }
            case UNION: {
                throw new UnsupportedOperationException("Cannot handle " + schema);
            }
            case LIST: {
                return visitor.list(schema, OrcSchemaVisitor.visit((TypeDescription)schema.getChildren().get(0), visitor));
            }
            case MAP: {
                return visitor.map(schema, OrcSchemaVisitor.visit((TypeDescription)schema.getChildren().get(0), visitor), OrcSchemaVisitor.visit((TypeDescription)schema.getChildren().get(1), visitor));
            }
        }
        return visitor.primitive(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> visitFields(List<TypeDescription> fields, List<String> names, OrcSchemaVisitor<T> visitor) {
        Preconditions.checkArgument((fields.size() == names.size() ? 1 : 0) != 0, (Object)"Not all fields have names in ORC struct");
        ArrayList results = Lists.newArrayListWithExpectedSize((int)fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            TypeDescription field = fields.get(i);
            String name = names.get(i);
            visitor.beforeField(name, field);
            try {
                results.add(OrcSchemaVisitor.visit(field, visitor));
                continue;
            }
            finally {
                visitor.afterField(name, field);
            }
        }
        return results;
    }

    private static <T> T visitRecord(TypeDescription record, OrcSchemaVisitor<T> visitor) {
        List fields = record.getChildren();
        List names = record.getFieldNames();
        return visitor.record(record, names, OrcSchemaVisitor.visitFields(fields, names, visitor));
    }

    public void beforeField(String name, TypeDescription type) {
    }

    public void afterField(String name, TypeDescription type) {
    }

    public T record(TypeDescription record, List<String> names, List<T> fields) {
        return null;
    }

    public T list(TypeDescription array, T element) {
        return null;
    }

    public T map(TypeDescription map, T key, T value) {
        return null;
    }

    public T primitive(TypeDescription primitive) {
        return null;
    }
}

