/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.Schema;
import org.apache.iceberg.common.DynFields;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.orc.OrcSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.BooleanColumnStatistics;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.DateColumnStatistics;
import org.apache.orc.DecimalColumnStatistics;
import org.apache.orc.DoubleColumnStatistics;
import org.apache.orc.IntegerColumnStatistics;
import org.apache.orc.Reader;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.TimestampColumnStatistics;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.impl.ColumnStatisticsImpl;

public class OrcMetrics {
    private static final Class<?> DATE_STATS_IMPL = Stream.of(ColumnStatisticsImpl.class.getDeclaredClasses()).filter(statsClass -> "DateStatisticsImpl".equals(statsClass.getSimpleName())).findFirst().orElse(null);
    private static final DynFields.UnboundField<Integer> DATE_MINIMUM = DynFields.builder().hiddenImpl(DATE_STATS_IMPL, "minimum").defaultAlwaysNull().build();
    private static final DynFields.UnboundField<Integer> DATE_MAXIMUM = DynFields.builder().hiddenImpl(DATE_STATS_IMPL, "maximum").defaultAlwaysNull().build();

    private OrcMetrics() {
    }

    public static Metrics fromInputFile(InputFile file) {
        Configuration config = file instanceof HadoopInputFile ? ((HadoopInputFile)file).getConf() : new Configuration();
        return OrcMetrics.fromInputFile(file, config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Metrics fromInputFile(InputFile file, Configuration config) {
        try (Reader orcReader = ORC.newFileReader(file, config);){
            Metrics metrics = OrcMetrics.buildOrcMetrics(orcReader.getNumberOfRows(), orcReader.getSchema(), orcReader.getStatistics());
            return metrics;
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to open file: %s", new Object[]{file.location()});
        }
    }

    static Metrics fromWriter(Writer writer) {
        try {
            return OrcMetrics.buildOrcMetrics(writer.getNumberOfRows(), writer.getSchema(), writer.getStatistics());
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to get statistics from writer", new Object[0]);
        }
    }

    private static Metrics buildOrcMetrics(long numOfRows, TypeDescription orcSchema, ColumnStatistics[] colStats) {
        Schema schema = ORCSchemaUtil.convert(orcSchema);
        Set<Integer> statsColumns = OrcMetrics.statsColumns(orcSchema);
        HashMap columnSizes = Maps.newHashMapWithExpectedSize((int)colStats.length);
        HashMap valueCounts = Maps.newHashMapWithExpectedSize((int)colStats.length);
        HashMap nullCounts = Maps.newHashMapWithExpectedSize((int)colStats.length);
        HashMap lowerBounds = Maps.newHashMap();
        HashMap upperBounds = Maps.newHashMap();
        for (int i = 0; i < colStats.length; ++i) {
            ColumnStatistics colStat = colStats[i];
            TypeDescription orcCol = orcSchema.findSubtype(i);
            Optional<Types.NestedField> icebergColOpt = ORCSchemaUtil.icebergID(orcCol).map(arg_0 -> ((Schema)schema).findField(arg_0));
            if (!icebergColOpt.isPresent()) continue;
            Types.NestedField icebergCol = icebergColOpt.get();
            int fieldId = icebergCol.fieldId();
            columnSizes.put(fieldId, colStat.getBytesOnDisk());
            if (!statsColumns.contains(fieldId)) continue;
            if (colStat.hasNull()) {
                nullCounts.put(fieldId, numOfRows - colStat.getNumberOfValues());
            } else {
                nullCounts.put(fieldId, 0L);
            }
            valueCounts.put(fieldId, colStat.getNumberOfValues() + (Long)nullCounts.get(fieldId));
            Optional<ByteBuffer> orcMin = colStat.getNumberOfValues() > 0L ? OrcMetrics.fromOrcMin(icebergCol, colStat) : Optional.empty();
            orcMin.ifPresent(byteBuffer -> lowerBounds.put(icebergCol.fieldId(), byteBuffer));
            Optional<ByteBuffer> orcMax = colStat.getNumberOfValues() > 0L ? OrcMetrics.fromOrcMax(icebergCol, colStat) : Optional.empty();
            orcMax.ifPresent(byteBuffer -> upperBounds.put(icebergCol.fieldId(), byteBuffer));
        }
        return new Metrics(Long.valueOf(numOfRows), (Map)columnSizes, (Map)valueCounts, (Map)nullCounts, (Map)lowerBounds, (Map)upperBounds);
    }

    private static Optional<ByteBuffer> fromOrcMin(Types.NestedField column, ColumnStatistics columnStats) {
        Object min = null;
        if (columnStats instanceof IntegerColumnStatistics) {
            min = ((IntegerColumnStatistics)columnStats).getMinimum();
            if (column.type().typeId() == Type.TypeID.INTEGER) {
                min = Math.toIntExact((Long)min);
            }
        } else if (columnStats instanceof DoubleColumnStatistics) {
            min = ((DoubleColumnStatistics)columnStats).getMinimum();
            if (column.type().typeId() == Type.TypeID.FLOAT) {
                min = Float.valueOf(((Double)min).floatValue());
            }
        } else if (columnStats instanceof StringColumnStatistics) {
            min = ((StringColumnStatistics)columnStats).getMinimum();
        } else if (columnStats instanceof DecimalColumnStatistics) {
            min = Optional.ofNullable(((DecimalColumnStatistics)columnStats).getMinimum()).map(minStats -> minStats.bigDecimalValue().setScale(((Types.DecimalType)column.type()).scale())).orElse(null);
        } else if (columnStats instanceof DateColumnStatistics) {
            min = Optional.ofNullable(OrcMetrics.minDayFromEpoch((DateColumnStatistics)columnStats)).orElse(null);
        } else if (columnStats instanceof TimestampColumnStatistics) {
            TimestampColumnStatistics tColStats = (TimestampColumnStatistics)columnStats;
            Timestamp minValue = tColStats.getMinimumUTC();
            min = Optional.ofNullable(minValue).map(v -> TimeUnit.MILLISECONDS.toMicros(v.getTime())).orElse(null);
        } else if (columnStats instanceof BooleanColumnStatistics) {
            BooleanColumnStatistics booleanStats = (BooleanColumnStatistics)columnStats;
            min = booleanStats.getFalseCount() <= 0L;
        }
        return Optional.ofNullable(Conversions.toByteBuffer((Type)column.type(), (Object)min));
    }

    private static Optional<ByteBuffer> fromOrcMax(Types.NestedField column, ColumnStatistics columnStats) {
        Object max = null;
        if (columnStats instanceof IntegerColumnStatistics) {
            max = ((IntegerColumnStatistics)columnStats).getMaximum();
            if (column.type().typeId() == Type.TypeID.INTEGER) {
                max = Math.toIntExact((Long)max);
            }
        } else if (columnStats instanceof DoubleColumnStatistics) {
            max = ((DoubleColumnStatistics)columnStats).getMaximum();
            if (column.type().typeId() == Type.TypeID.FLOAT) {
                max = Float.valueOf(((Double)max).floatValue());
            }
        } else if (columnStats instanceof StringColumnStatistics) {
            max = ((StringColumnStatistics)columnStats).getMaximum();
        } else if (columnStats instanceof DecimalColumnStatistics) {
            max = Optional.ofNullable(((DecimalColumnStatistics)columnStats).getMaximum()).map(maxStats -> maxStats.bigDecimalValue().setScale(((Types.DecimalType)column.type()).scale())).orElse(null);
        } else if (columnStats instanceof DateColumnStatistics) {
            max = Optional.ofNullable(OrcMetrics.maxDayFromEpoch((DateColumnStatistics)columnStats)).orElse(null);
        } else if (columnStats instanceof TimestampColumnStatistics) {
            TimestampColumnStatistics tColStats = (TimestampColumnStatistics)columnStats;
            Timestamp maxValue = tColStats.getMaximumUTC();
            max = Optional.ofNullable(maxValue).map(v -> TimeUnit.MILLISECONDS.toMicros(v.getTime())).map(v -> v + 1000L).orElse(null);
        } else if (columnStats instanceof BooleanColumnStatistics) {
            BooleanColumnStatistics booleanStats = (BooleanColumnStatistics)columnStats;
            max = booleanStats.getTrueCount() > 0L;
        }
        return Optional.ofNullable(Conversions.toByteBuffer((Type)column.type(), (Object)max));
    }

    private static Set<Integer> statsColumns(TypeDescription schema) {
        return OrcSchemaVisitor.visit(schema, new StatsColumnsVisitor());
    }

    private static Integer minDayFromEpoch(DateColumnStatistics stats) {
        return (Integer)DATE_MINIMUM.get((Object)stats);
    }

    private static Integer maxDayFromEpoch(DateColumnStatistics stats) {
        return (Integer)DATE_MAXIMUM.get((Object)stats);
    }

    private static class StatsColumnsVisitor
    extends OrcSchemaVisitor<Set<Integer>> {
        private StatsColumnsVisitor() {
        }

        @Override
        public Set<Integer> record(TypeDescription record, List<String> names, List<Set<Integer>> fields) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            fields.stream().filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableSet.Builder)result).addAll(arg_0));
            record.getChildren().stream().map(ORCSchemaUtil::fieldId).forEach(arg_0 -> ((ImmutableSet.Builder)result).add(arg_0));
            return result.build();
        }
    }
}

