/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ExpressionToSearchArgument;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.orc.OrcRowReader;
import org.apache.iceberg.orc.VectorizedRowBatchIterator;
import org.apache.iceberg.types.Types;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.storage.ql.io.sarg.SearchArgument;

class OrcIterable<T>
extends CloseableGroup
implements CloseableIterable<T> {
    private final Configuration config;
    private final Schema schema;
    private final InputFile file;
    private final Long start;
    private final Long length;
    private final Function<TypeDescription, OrcRowReader<?>> readerFunction;
    private final Expression filter;
    private final boolean caseSensitive;

    OrcIterable(InputFile file, Configuration config, Schema schema, Long start, Long length, Function<TypeDescription, OrcRowReader<?>> readerFunction, boolean caseSensitive, Expression filter) {
        this.schema = schema;
        this.readerFunction = readerFunction;
        this.file = file;
        this.start = start;
        this.length = length;
        this.config = config;
        this.caseSensitive = caseSensitive;
        this.filter = filter == Expressions.alwaysTrue() ? null : filter;
    }

    public CloseableIterator<T> iterator() {
        Reader orcFileReader = ORC.newFileReader(this.file, this.config);
        this.addCloseable((Closeable)orcFileReader);
        TypeDescription readOrcSchema = ORCSchemaUtil.buildOrcProjection(this.schema, orcFileReader.getSchema());
        SearchArgument sarg = null;
        if (this.filter != null) {
            Expression boundFilter = Binder.bind((Types.StructType)this.schema.asStruct(), (Expression)this.filter, (boolean)this.caseSensitive);
            sarg = ExpressionToSearchArgument.convert(boundFilter, readOrcSchema);
        }
        OrcIterator iterator = new OrcIterator(OrcIterable.newOrcIterator(this.file, readOrcSchema, this.start, this.length, orcFileReader, sarg), this.readerFunction.apply(readOrcSchema));
        return CloseableIterator.withClose(iterator);
    }

    private static VectorizedRowBatchIterator newOrcIterator(InputFile file, TypeDescription readerSchema, Long start, Long length, Reader orcFileReader, SearchArgument sarg) {
        Reader.Options options = orcFileReader.options();
        if (start != null) {
            options.range(start.longValue(), length.longValue());
        }
        options.schema(readerSchema);
        options.searchArgument(sarg, new String[0]);
        try {
            return new VectorizedRowBatchIterator(file.location(), readerSchema, orcFileReader.rows(options));
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to get ORC rows for file: %s", new Object[]{file});
        }
    }

    private static class OrcIterator<T>
    implements Iterator<T> {
        private int nextRow;
        private VectorizedRowBatch current;
        private final VectorizedRowBatchIterator batchIter;
        private final OrcRowReader<T> reader;

        OrcIterator(VectorizedRowBatchIterator batchIter, OrcRowReader<T> reader) {
            this.batchIter = batchIter;
            this.reader = reader;
            this.current = null;
            this.nextRow = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current != null && this.nextRow < this.current.size || this.batchIter.hasNext();
        }

        @Override
        public T next() {
            if (this.current == null || this.nextRow >= this.current.size) {
                this.current = this.batchIter.next();
                this.nextRow = 0;
            }
            return this.reader.read(this.current, this.nextRow++);
        }
    }
}

