/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieIcebergClient;
import org.apache.iceberg.nessie.NessieUtil;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.error.ReferenceConflicts;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(NessieTableOperations.class);
    public static final String NESSIE_COMMIT_ID_PROPERTY = "nessie.commit.id";
    public static final String NESSIE_GC_NO_WARNING_PROPERTY = "nessie.gc.no-warning";
    private final NessieIcebergClient client;
    private final ContentKey key;
    private IcebergTable table;
    private final FileIO fileIO;
    private final Map<String, String> catalogOptions;

    NessieTableOperations(ContentKey key, NessieIcebergClient client, FileIO fileIO, Map<String, String> catalogOptions) {
        this.key = key;
        this.client = client;
        this.fileIO = fileIO;
        this.catalogOptions = catalogOptions;
    }

    protected String tableName() {
        return this.key.toString();
    }

    protected void doRefresh() {
        Reference reference;
        String metadataLocation;
        block7: {
            try {
                this.client.refresh();
            }
            catch (NessieNotFoundException e) {
                throw new RuntimeException(String.format("Failed to refresh as ref '%s' is no longer valid.", this.client.getRef().getName()), e);
            }
            metadataLocation = null;
            reference = this.client.getRef().getReference();
            try {
                Content content = (Content)((GetContentBuilder)this.client.getApi().getContent().key(this.key).reference(reference)).get().get(this.key);
                LOG.debug("Content '{}' at '{}': {}", new Object[]{this.key, reference, content});
                if (content == null) {
                    if (this.currentMetadataLocation() != null) {
                        throw new NoSuchTableException("No such table '%s' in '%s'", new Object[]{this.key, reference});
                    }
                } else {
                    this.table = (IcebergTable)content.unwrap(IcebergTable.class).orElseThrow(() -> new IllegalStateException(String.format("Cannot refresh iceberg table: Nessie points to a non-Iceberg object for path: %s.", this.key)));
                    metadataLocation = this.table.getMetadataLocation();
                }
            }
            catch (NessieNotFoundException ex) {
                if (this.currentMetadataLocation() == null) break block7;
                throw new NoSuchTableException((Throwable)ex, "No such table '%s'", new Object[]{this.key});
            }
        }
        this.refreshFromMetadataLocation(metadataLocation, null, 2, location -> NessieUtil.updateTableMetadataWithNessieSpecificProperties(TableMetadataParser.read((FileIO)this.fileIO, (String)location), location, this.table, this.key.toString(), reference));
    }

    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        boolean newTable = base == null;
        String newMetadataLocation = this.writeNewMetadataIfRequired(newTable, metadata);
        String refName = this.client.refName();
        boolean failure = false;
        try {
            this.client.commitTable(base, metadata, newMetadataLocation, this.table, this.key);
        }
        catch (NessieConflictException ex) {
            failure = true;
            if (ex instanceof NessieReferenceConflictException) {
                NessieTableOperations.maybeThrowSpecializedException((NessieReferenceConflictException)ex);
            }
            throw new CommitFailedException((Throwable)ex, "Cannot commit: Reference hash is out of date. Update the reference '%s' and try again", new Object[]{refName});
        }
        catch (HttpClientException ex) {
            throw new CommitStateUnknownException((Throwable)ex);
        }
        catch (NessieNotFoundException ex) {
            failure = true;
            throw new RuntimeException(String.format("Cannot commit: Reference '%s' no longer exists", refName), ex);
        }
        finally {
            if (failure) {
                this.io().deleteFile(newMetadataLocation);
            }
        }
    }

    private static void maybeThrowSpecializedException(NessieReferenceConflictException ex) {
        ReferenceConflicts referenceConflicts = ex.getErrorDetails();
        if (referenceConflicts == null) {
            return;
        }
        List conflicts = referenceConflicts.conflicts();
        if (conflicts.size() != 1) {
            return;
        }
        Conflict conflict = (Conflict)conflicts.get(0);
        Conflict.ConflictType conflictType = conflict.conflictType();
        if (conflictType != null) {
            switch (conflictType) {
                case NAMESPACE_ABSENT: {
                    throw new NoSuchNamespaceException((Throwable)ex, "Namespace does not exist: %s", new Object[]{conflict.key()});
                }
                case NAMESPACE_NOT_EMPTY: {
                    throw new NamespaceNotEmptyException((Throwable)ex, "Namespace not empty: %s", new Object[]{conflict.key()});
                }
                case KEY_DOES_NOT_EXIST: {
                    throw new NoSuchTableException((Throwable)ex, "Table or view does not exist: %s", new Object[]{conflict.key()});
                }
                case KEY_EXISTS: {
                    throw new AlreadyExistsException((Throwable)ex, "Table or view already exists: %s", new Object[]{conflict.key()});
                }
            }
        }
    }

    public FileIO io() {
        return this.fileIO;
    }
}

