/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.mr.mapreduce.IcebergSplitContainer;
import org.apache.iceberg.util.SerializationUtil;

public class IcebergSplit
extends InputSplit
implements org.apache.hadoop.mapred.InputSplit,
IcebergSplitContainer {
    private static final String[] ANYWHERE = new String[]{"*"};
    private Table table;
    private CombinedScanTask task;
    private transient String[] locations;
    private transient Configuration conf;

    public IcebergSplit() {
    }

    IcebergSplit(Table table, Configuration conf, CombinedScanTask task) {
        this.table = table;
        this.task = task;
        this.conf = conf;
    }

    public CombinedScanTask task() {
        return this.task;
    }

    @Override
    public IcebergSplit icebergSplit() {
        return this;
    }

    public long getLength() {
        return this.task.files().stream().mapToLong(ContentScanTask::length).sum();
    }

    public String[] getLocations() {
        boolean localityPreferred;
        this.locations = this.locations == null && this.conf != null ? ((localityPreferred = this.conf.getBoolean("iceberg.mr.locality", false)) ? Util.blockLocations((ScanTaskGroup)this.task, (Configuration)this.conf) : (String[])ANYWHERE.clone()) : (String[])ANYWHERE.clone();
        return this.locations;
    }

    public void write(DataOutput out) throws IOException {
        byte[] tableData = SerializationUtil.serializeToBytes((Object)this.table);
        out.writeInt(tableData.length);
        out.write(tableData);
        byte[] data = SerializationUtil.serializeToBytes((Object)this.task);
        out.writeInt(data.length);
        out.write(data);
    }

    public void readFields(DataInput in) throws IOException {
        byte[] tableData = new byte[in.readInt()];
        in.readFully(tableData);
        this.table = (Table)SerializationUtil.deserializeFromBytes((byte[])tableData);
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        this.task = (CombinedScanTask)SerializationUtil.deserializeFromBytes((byte[])data);
    }

    public Table table() {
        return this.table;
    }
}

