/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.mr.hive.serde.objectinspector.WriteObjectInspector;

public class IcebergTimestampObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements TimestampObjectInspector,
WriteObjectInspector {
    private static final IcebergTimestampObjectInspector INSTANCE = new IcebergTimestampObjectInspector();

    public static IcebergTimestampObjectInspector get() {
        return INSTANCE;
    }

    private IcebergTimestampObjectInspector() {
        super(TypeInfoFactory.timestampTypeInfo);
    }

    @Override
    public LocalDateTime convert(Object o) {
        return o == null ? null : ((Timestamp)o).toLocalDateTime();
    }

    public Timestamp getPrimitiveJavaObject(Object o) {
        return o == null ? null : Timestamp.valueOf((LocalDateTime)o);
    }

    public TimestampWritable getPrimitiveWritableObject(Object o) {
        Timestamp ts = this.getPrimitiveJavaObject(o);
        return ts == null ? null : new TimestampWritable(ts);
    }

    public Object copyObject(Object o) {
        if (o instanceof Timestamp) {
            Timestamp ts = (Timestamp)o;
            Timestamp copy = new Timestamp(ts.getTime());
            copy.setNanos(ts.getNanos());
            return copy;
        }
        if (o instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)o;
            return LocalDateTime.of(ldt.toLocalDate(), ldt.toLocalTime());
        }
        return o;
    }
}

