/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.hive.serde.objectinspector.WriteObjectInspector;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.schema.SchemaWithPartnerVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class Deserializer {
    private final FieldDeserializer fieldDeserializer;

    Record deserialize(Object data) {
        return (Record)this.fieldDeserializer.value(data);
    }

    private Deserializer(Schema schema, ObjectInspectorPair pair) {
        this.fieldDeserializer = DeserializerVisitor.visit(schema, pair);
    }

    private static class ObjectInspectorPair {
        private final ObjectInspector writerInspector;
        private final ObjectInspector sourceInspector;

        ObjectInspectorPair(ObjectInspector writerInspector, ObjectInspector sourceInspector) {
            this.writerInspector = writerInspector;
            this.sourceInspector = sourceInspector;
        }

        ObjectInspector writerInspector() {
            return this.writerInspector;
        }

        ObjectInspector sourceInspector() {
            return this.sourceInspector;
        }

        String sourceName(String originalName) {
            return originalName;
        }
    }

    private static class FixNameMappingObjectInspectorPair
    extends ObjectInspectorPair {
        private final Map<String, String> sourceNameMap;

        FixNameMappingObjectInspectorPair(Schema schema, ObjectInspectorPair pair) {
            super(pair.writerInspector(), pair.sourceInspector());
            this.sourceNameMap = Maps.newHashMapWithExpectedSize((int)schema.columns().size());
            List fields = ((StructObjectInspector)this.sourceInspector()).getAllStructFieldRefs();
            for (int i = 0; i < schema.columns().size(); ++i) {
                this.sourceNameMap.put(((Types.NestedField)schema.columns().get(i)).name(), ((StructField)fields.get(i)).getFieldName());
            }
        }

        @Override
        String sourceName(String originalName) {
            return this.sourceNameMap.get(originalName);
        }
    }

    private static interface FieldDeserializer {
        public Object value(Object var1);
    }

    private static class PartnerObjectInspectorByNameAccessors
    implements SchemaWithPartnerVisitor.PartnerAccessors<ObjectInspectorPair> {
        private PartnerObjectInspectorByNameAccessors() {
        }

        public ObjectInspectorPair fieldPartner(ObjectInspectorPair pair, int fieldId, String name) {
            String sourceName = pair.sourceName(name);
            return new ObjectInspectorPair(((StructObjectInspector)pair.writerInspector()).getStructFieldRef(name).getFieldObjectInspector(), ((StructObjectInspector)pair.sourceInspector()).getStructFieldRef(sourceName).getFieldObjectInspector());
        }

        public ObjectInspectorPair mapKeyPartner(ObjectInspectorPair pair) {
            return new ObjectInspectorPair(((MapObjectInspector)pair.writerInspector()).getMapKeyObjectInspector(), ((MapObjectInspector)pair.sourceInspector()).getMapKeyObjectInspector());
        }

        public ObjectInspectorPair mapValuePartner(ObjectInspectorPair pair) {
            return new ObjectInspectorPair(((MapObjectInspector)pair.writerInspector()).getMapValueObjectInspector(), ((MapObjectInspector)pair.sourceInspector()).getMapValueObjectInspector());
        }

        public ObjectInspectorPair listElementPartner(ObjectInspectorPair pair) {
            return new ObjectInspectorPair(((ListObjectInspector)pair.writerInspector()).getListElementObjectInspector(), ((ListObjectInspector)pair.sourceInspector()).getListElementObjectInspector());
        }
    }

    private static class DeserializerVisitor
    extends SchemaWithPartnerVisitor<ObjectInspectorPair, FieldDeserializer> {
        private DeserializerVisitor() {
        }

        public static FieldDeserializer visit(Schema schema, ObjectInspectorPair pair) {
            return (FieldDeserializer)DeserializerVisitor.visit((Schema)schema, (Object)new FixNameMappingObjectInspectorPair(schema, pair), (SchemaWithPartnerVisitor)new DeserializerVisitor(), (SchemaWithPartnerVisitor.PartnerAccessors)new PartnerObjectInspectorByNameAccessors());
        }

        public FieldDeserializer schema(Schema schema, ObjectInspectorPair pair, FieldDeserializer deserializer) {
            return deserializer;
        }

        public FieldDeserializer field(Types.NestedField field, ObjectInspectorPair pair, FieldDeserializer deserializer) {
            return deserializer;
        }

        public FieldDeserializer primitive(Type.PrimitiveType type, ObjectInspectorPair pair) {
            return o -> {
                if (o == null) {
                    return null;
                }
                ObjectInspector writerFieldInspector = pair.writerInspector();
                ObjectInspector sourceFieldInspector = pair.sourceInspector();
                Object result = ((PrimitiveObjectInspector)sourceFieldInspector).getPrimitiveJavaObject(o);
                if (writerFieldInspector instanceof WriteObjectInspector) {
                    result = ((WriteObjectInspector)writerFieldInspector).convert(result);
                }
                return result;
            };
        }

        public FieldDeserializer struct(Types.StructType type, ObjectInspectorPair pair, List<FieldDeserializer> deserializers) {
            Preconditions.checkNotNull((Object)type, (Object)"Can not create reader for null type");
            GenericRecord template = GenericRecord.create((Types.StructType)type);
            return o -> {
                if (o == null) {
                    return null;
                }
                List data = ((StructObjectInspector)pair.sourceInspector()).getStructFieldsDataAsList(o);
                GenericRecord result = template.copy();
                for (int i = 0; i < deserializers.size(); ++i) {
                    Object fieldValue = data.get(i);
                    if (fieldValue != null) {
                        result.set(i, ((FieldDeserializer)deserializers.get(i)).value(fieldValue));
                        continue;
                    }
                    result.set(i, null);
                }
                return result;
            };
        }

        public FieldDeserializer list(Types.ListType listTypeInfo, ObjectInspectorPair pair, FieldDeserializer deserializer) {
            return o -> {
                if (o == null) {
                    return null;
                }
                ArrayList result = Lists.newArrayList();
                ListObjectInspector listInspector = (ListObjectInspector)pair.sourceInspector();
                for (Object val : listInspector.getList(o)) {
                    result.add(deserializer.value(val));
                }
                return result;
            };
        }

        public FieldDeserializer map(Types.MapType mapType, ObjectInspectorPair pair, FieldDeserializer keyDeserializer, FieldDeserializer valueDeserializer) {
            return o -> {
                if (o == null) {
                    return null;
                }
                HashMap result = Maps.newHashMap();
                MapObjectInspector mapObjectInspector = (MapObjectInspector)pair.sourceInspector();
                for (Map.Entry entry : mapObjectInspector.getMap(o).entrySet()) {
                    result.put(keyDeserializer.value(entry.getKey()), valueDeserializer.value(entry.getValue()));
                }
                return result;
            };
        }
    }

    static class Builder {
        private Schema schema;
        private StructObjectInspector writerInspector;
        private StructObjectInspector sourceInspector;

        Builder() {
        }

        Builder schema(Schema mainSchema) {
            this.schema = mainSchema;
            return this;
        }

        Builder writerInspector(StructObjectInspector inspector) {
            this.writerInspector = inspector;
            return this;
        }

        Builder sourceInspector(StructObjectInspector inspector) {
            this.sourceInspector = inspector;
            return this;
        }

        Deserializer build() {
            return new Deserializer(this.schema, new ObjectInspectorPair((ObjectInspector)this.writerInspector, (ObjectInspector)this.sourceInspector));
        }
    }
}

