/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.iceberg.mr.hive.serde.objectinspector.WriteObjectInspector;
import org.apache.iceberg.util.ByteBuffers;

public class IcebergBinaryObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements BinaryObjectInspector,
WriteObjectInspector {
    private static final IcebergBinaryObjectInspector INSTANCE = new IcebergBinaryObjectInspector();

    public static IcebergBinaryObjectInspector get() {
        return INSTANCE;
    }

    private IcebergBinaryObjectInspector() {
        super(TypeInfoFactory.binaryTypeInfo);
    }

    public byte[] getPrimitiveJavaObject(Object o) {
        return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)o));
    }

    public BytesWritable getPrimitiveWritableObject(Object o) {
        return o == null ? null : new BytesWritable(this.getPrimitiveJavaObject(o));
    }

    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            return Arrays.copyOf(bytes, bytes.length);
        }
        if (o instanceof ByteBuffer) {
            ByteBuffer copy = ByteBuffer.wrap(((ByteBuffer)o).array(), ((ByteBuffer)o).arrayOffset(), ((ByteBuffer)o).limit());
            return copy;
        }
        return o;
    }

    @Override
    public ByteBuffer convert(Object o) {
        return o == null ? null : ByteBuffer.wrap((byte[])o);
    }
}

