/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.Schema;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.hive.MetastoreUtil;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergBinaryObjectInspector;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergDecimalObjectInspector;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergFixedObjectInspector;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergRecordObjectInspector;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergTimeObjectInspector;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergUUIDObjectInspector;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public final class IcebergObjectInspector
extends TypeUtil.SchemaVisitor<ObjectInspector> {
    private static final String DATE_INSPECTOR_CLASS = MetastoreUtil.hive3PresentOnClasspath() ? "org.apache.iceberg.mr.hive.serde.objectinspector.IcebergDateObjectInspectorHive3" : "org.apache.iceberg.mr.hive.serde.objectinspector.IcebergDateObjectInspector";
    public static final ObjectInspector DATE_INSPECTOR = (ObjectInspector)DynMethods.builder((String)"get").impl(DATE_INSPECTOR_CLASS, new Class[0]).buildStatic().invoke(new Object[0]);
    private static final String TIMESTAMP_INSPECTOR_CLASS = MetastoreUtil.hive3PresentOnClasspath() ? "org.apache.iceberg.mr.hive.serde.objectinspector.IcebergTimestampObjectInspectorHive3" : "org.apache.iceberg.mr.hive.serde.objectinspector.IcebergTimestampObjectInspector";
    private static final String TIMESTAMPTZ_INSPECTOR_CLASS = MetastoreUtil.hive3PresentOnClasspath() ? "org.apache.iceberg.mr.hive.serde.objectinspector.IcebergTimestampWithZoneObjectInspectorHive3" : "org.apache.iceberg.mr.hive.serde.objectinspector.IcebergTimestampWithZoneObjectInspector";
    public static final ObjectInspector TIMESTAMP_INSPECTOR = (ObjectInspector)DynMethods.builder((String)"get").impl(TIMESTAMP_INSPECTOR_CLASS, new Class[0]).buildStatic().invoke(new Object[0]);
    public static final ObjectInspector TIMESTAMP_INSPECTOR_WITH_TZ = (ObjectInspector)DynMethods.builder((String)"get").impl(TIMESTAMPTZ_INSPECTOR_CLASS, new Class[0]).buildStatic().invoke(new Object[0]);

    public static ObjectInspector create(@Nullable Schema schema) {
        if (schema == null) {
            return IcebergRecordObjectInspector.empty();
        }
        return (ObjectInspector)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)new IcebergObjectInspector());
    }

    public static ObjectInspector create(Types.NestedField ... fields) {
        return IcebergObjectInspector.create(new Schema(fields));
    }

    public ObjectInspector field(Types.NestedField field, ObjectInspector fieldObjectInspector) {
        return fieldObjectInspector;
    }

    public ObjectInspector list(Types.ListType listTypeInfo, ObjectInspector listObjectInspector) {
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)listObjectInspector);
    }

    public ObjectInspector map(Types.MapType mapType, ObjectInspector keyObjectInspector, ObjectInspector valueObjectInspector) {
        return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyObjectInspector, (ObjectInspector)valueObjectInspector);
    }

    public ObjectInspector primitive(Type.PrimitiveType primitiveType) {
        PrimitiveTypeInfo primitiveTypeInfo;
        switch (primitiveType.typeId()) {
            case BINARY: {
                return IcebergBinaryObjectInspector.get();
            }
            case BOOLEAN: {
                primitiveTypeInfo = TypeInfoFactory.booleanTypeInfo;
                break;
            }
            case DATE: {
                return DATE_INSPECTOR;
            }
            case DECIMAL: {
                Types.DecimalType type = (Types.DecimalType)primitiveType;
                return IcebergDecimalObjectInspector.get(type.precision(), type.scale());
            }
            case DOUBLE: {
                primitiveTypeInfo = TypeInfoFactory.doubleTypeInfo;
                break;
            }
            case FIXED: {
                return IcebergFixedObjectInspector.get();
            }
            case FLOAT: {
                primitiveTypeInfo = TypeInfoFactory.floatTypeInfo;
                break;
            }
            case INTEGER: {
                primitiveTypeInfo = TypeInfoFactory.intTypeInfo;
                break;
            }
            case LONG: {
                primitiveTypeInfo = TypeInfoFactory.longTypeInfo;
                break;
            }
            case STRING: {
                primitiveTypeInfo = TypeInfoFactory.stringTypeInfo;
                break;
            }
            case UUID: {
                return IcebergUUIDObjectInspector.get();
            }
            case TIMESTAMP: {
                boolean adjustToUTC = ((Types.TimestampType)primitiveType).shouldAdjustToUTC();
                return adjustToUTC ? TIMESTAMP_INSPECTOR_WITH_TZ : TIMESTAMP_INSPECTOR;
            }
            case TIME: {
                return IcebergTimeObjectInspector.get();
            }
            default: {
                throw new IllegalArgumentException(primitiveType.typeId() + " type is not supported");
            }
        }
        return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)primitiveTypeInfo);
    }

    public ObjectInspector schema(Schema schema, ObjectInspector structObjectInspector) {
        return structObjectInspector;
    }

    public ObjectInspector struct(Types.StructType structType, List<ObjectInspector> fieldObjectInspectors) {
        return new IcebergRecordObjectInspector(structType, fieldObjectInspectors);
    }
}

