/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.hive.Deserializer;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergObjectInspector;
import org.apache.iceberg.mr.mapred.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergSerDe
extends AbstractSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergSerDe.class);
    private static final String LIST_COLUMN_COMMENT = "columns.comments";
    private ObjectInspector inspector;
    private Schema tableSchema;
    private Map<ObjectInspector, Deserializer> deserializers = new HashMap<ObjectInspector, Deserializer>(1);
    private Container<Record> row = new Container();

    public void initialize(@Nullable Configuration configuration, Properties serDeProperties) throws SerDeException {
        Schema projectedSchema;
        if (serDeProperties.get("iceberg.mr.table.schema") != null) {
            this.tableSchema = SchemaParser.fromJson((String)((String)serDeProperties.get("iceberg.mr.table.schema")));
        } else {
            try {
                this.tableSchema = Catalogs.loadTable(configuration, serDeProperties).schema();
                LOG.info("Using schema from existing table {}", (Object)SchemaParser.toJson((Schema)this.tableSchema));
            }
            catch (Exception e) {
                boolean autoConversion = configuration.getBoolean("iceberg.mr.schema.auto.conversion", false);
                this.tableSchema = HiveIcebergSerDe.hiveSchemaOrThrow(serDeProperties, e, autoConversion);
            }
        }
        if (serDeProperties.get("HiveIcebergStorageHandler_write") != null) {
            projectedSchema = this.tableSchema;
        } else {
            configuration.setBoolean("iceberg.mr.case.sensitive", false);
            String[] selectedColumns = ColumnProjectionUtils.getReadColumnNames((Configuration)configuration);
            String[] distinctSelectedColumns = (String[])Arrays.stream(selectedColumns).distinct().toArray(String[]::new);
            Schema schema = projectedSchema = distinctSelectedColumns.length > 0 ? this.tableSchema.caseInsensitiveSelect(distinctSelectedColumns) : this.tableSchema;
            if (projectedSchema.columns().size() != distinctSelectedColumns.length) {
                projectedSchema = this.tableSchema;
            }
        }
        try {
            this.inspector = IcebergObjectInspector.create(projectedSchema);
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }

    public Class<? extends Writable> getSerializedClass() {
        return Container.class;
    }

    public Writable serialize(Object o, ObjectInspector objectInspector) {
        Deserializer deserializer = this.deserializers.get(objectInspector);
        if (deserializer == null) {
            deserializer = new Deserializer.Builder().schema(this.tableSchema).sourceInspector((StructObjectInspector)objectInspector).writerInspector((StructObjectInspector)this.inspector).build();
            this.deserializers.put(objectInspector, deserializer);
        }
        this.row.set(deserializer.deserialize(o));
        return this.row;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Object deserialize(Writable writable) {
        return ((Container)writable).get();
    }

    public ObjectInspector getObjectInspector() {
        return this.inspector;
    }

    private static Schema hiveSchemaOrThrow(Properties serDeProperties, Exception previousException, boolean autoConversion) throws SerDeException {
        String columnNameDelimiter;
        String columnNames = serDeProperties.getProperty("columns");
        String columnTypes = serDeProperties.getProperty("columns.types");
        String columnComments = serDeProperties.getProperty(LIST_COLUMN_COMMENT);
        String string = columnNameDelimiter = serDeProperties.containsKey("column.name.delimiter") ? serDeProperties.getProperty("column.name.delimiter") : String.valueOf(',');
        if (!(columnNames == null || columnTypes == null || columnNameDelimiter == null || columnNames.isEmpty() || columnTypes.isEmpty() || columnNameDelimiter.isEmpty())) {
            ArrayList names = new ArrayList();
            Collections.addAll(names, columnNames.split(columnNameDelimiter));
            ArrayList comments = new ArrayList();
            if (columnComments != null) {
                Collections.addAll(comments, columnComments.split(Character.toString('\u0000')));
            }
            Schema hiveSchema = HiveSchemaUtil.convert(names, (List)TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypes), comments, (boolean)autoConversion);
            LOG.info("Using hive schema {}", (Object)SchemaParser.toJson((Schema)hiveSchema));
            return hiveSchema;
        }
        throw new SerDeException("Please provide an existing table or a valid schema", (Throwable)previousException);
    }
}

