/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitionedFanoutWriter;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HiveIcebergRecordWriter
extends PartitionedFanoutWriter<Record>
implements FileSinkOperator.RecordWriter,
RecordWriter<NullWritable, Container<Record>> {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergRecordWriter.class);
    private final PartitionKey currentKey;
    private final FileIO io;
    private static final Map<TaskAttemptID, Map<String, HiveIcebergRecordWriter>> writers = Maps.newConcurrentMap();

    static Map<String, HiveIcebergRecordWriter> removeWriters(TaskAttemptID taskAttemptID) {
        return writers.remove(taskAttemptID);
    }

    static Map<String, HiveIcebergRecordWriter> getWriters(TaskAttemptID taskAttemptID) {
        return writers.get(taskAttemptID);
    }

    HiveIcebergRecordWriter(Schema schema, PartitionSpec spec, FileFormat format, FileAppenderFactory<Record> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, TaskAttemptID taskAttemptID, String tableName) {
        super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
        this.io = io;
        this.currentKey = new PartitionKey(spec, schema);
        writers.putIfAbsent(taskAttemptID, Maps.newConcurrentMap());
        writers.get(taskAttemptID).put(tableName, this);
    }

    protected PartitionKey partition(Record row) {
        this.currentKey.partition((StructLike)row);
        return this.currentKey;
    }

    public void write(Writable row) throws IOException {
        super.write((Object)((Record)((Container)row).get()));
    }

    public void write(NullWritable key, Container value) throws IOException {
        this.write(value);
    }

    public void close(boolean abort) throws IOException {
        Object[] dataFiles = super.dataFiles();
        if (abort) {
            Tasks.foreach((Object[])dataFiles).retry(3).suppressFailureWhenFinished().onFailure((file, exception) -> LOG.debug("Failed on to remove file {} on abort", file, (Object)exception)).run(dataFile -> this.io.deleteFile(dataFile.path().toString()));
        }
        LOG.info("IcebergRecordWriter is closed with abort={}. Created {} files", (Object)abort, (Object)dataFiles.length);
    }

    public void close(Reporter reporter) throws IOException {
        this.close(false);
    }
}

