/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.util.List;
import org.apache.flink.types.Row;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.parquet.BaseParquetReaders;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class FlinkParquetReaders
extends BaseParquetReaders<Row> {
    private static final FlinkParquetReaders INSTANCE = new FlinkParquetReaders();

    private FlinkParquetReaders() {
    }

    public static ParquetValueReader<Row> buildReader(Schema expectedSchema, MessageType fileSchema) {
        return INSTANCE.createReader(expectedSchema, fileSchema);
    }

    protected ParquetValueReader<Row> createStructReader(List<Type> types, List<ParquetValueReader<?>> fieldReaders, Types.StructType structType) {
        return new RowReader(types, fieldReaders, structType);
    }

    private static class RowReader
    extends ParquetValueReaders.StructReader<Row, Row> {
        private final Types.StructType structType;

        RowReader(List<Type> types, List<ParquetValueReader<?>> readers, Types.StructType struct) {
            super(types, readers);
            this.structType = struct;
        }

        protected Row newStructData(Row reuse) {
            if (reuse != null) {
                return reuse;
            }
            return new Row(this.structType.fields().size());
        }

        protected Object getField(Row row, int pos) {
            return row.getField(pos);
        }

        protected Row buildStruct(Row row) {
            return row;
        }

        protected void set(Row row, int pos, Object value) {
            row.setField(pos, value);
        }
    }
}

