/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.util.List;
import java.util.Map;
import org.apache.flink.types.Row;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Types;

public class FlinkAvroReader
extends DataReader<Row> {
    public FlinkAvroReader(Schema expectedSchema, org.apache.avro.Schema readSchema) {
        super(expectedSchema, readSchema, (Map)ImmutableMap.of());
    }

    protected ValueReader<?> createStructReader(Types.StructType struct, List<ValueReader<?>> fields, Map<Integer, ?> idToConstant) {
        return new RowReader(fields, struct, idToConstant);
    }

    private static class RowReader
    extends ValueReaders.StructReader<Row> {
        private final Types.StructType structType;

        private RowReader(List<ValueReader<?>> readers, Types.StructType struct, Map<Integer, ?> idToConstant) {
            super(readers, struct, idToConstant);
            this.structType = struct;
        }

        protected Row reuseOrCreate(Object reuse) {
            if (reuse instanceof Row) {
                return (Row)reuse;
            }
            return new Row(this.structType.fields().size());
        }

        protected Object get(Row row, int pos) {
            return row.getField(pos);
        }

        protected void set(Row row, int pos, Object value) {
            row.setField(pos, value);
        }
    }
}

