/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class FlinkTypeVisitor<T> {
    static <T> T visit(DataType dataType, FlinkTypeVisitor<T> visitor) {
        if (dataType instanceof FieldsDataType) {
            FieldsDataType fieldsType = (FieldsDataType)dataType;
            Map fields = fieldsType.getFieldDataTypes();
            ArrayList fieldResults = Lists.newArrayList();
            Preconditions.checkArgument((boolean)(dataType.getLogicalType() instanceof RowType), (Object)"The logical type must be RowType");
            List rowFields = ((RowType)dataType.getLogicalType()).getFields();
            for (RowType.RowField rowField : rowFields) {
                String name = rowField.getName();
                fieldResults.add(FlinkTypeVisitor.visit((DataType)fields.get(name), visitor));
            }
            return visitor.fields(fieldsType, fieldResults);
        }
        if (dataType instanceof CollectionDataType) {
            CollectionDataType collectionType = (CollectionDataType)dataType;
            return visitor.collection(collectionType, FlinkTypeVisitor.visit(collectionType.getElementDataType(), visitor));
        }
        if (dataType instanceof KeyValueDataType) {
            KeyValueDataType mapType = (KeyValueDataType)dataType;
            return visitor.map(mapType, FlinkTypeVisitor.visit(mapType.getKeyDataType(), visitor), FlinkTypeVisitor.visit(mapType.getValueDataType(), visitor));
        }
        if (dataType instanceof AtomicDataType) {
            AtomicDataType atomic = (AtomicDataType)dataType;
            return visitor.atomic(atomic);
        }
        throw new UnsupportedOperationException("Unsupported data type: " + dataType);
    }

    public T fields(FieldsDataType type, List<T> fieldResults) {
        return null;
    }

    public T collection(CollectionDataType type, T elementResult) {
        return null;
    }

    public T map(KeyValueDataType type, T keyResult, T valueResult) {
        return null;
    }

    public T atomic(AtomicDataType type) {
        return null;
    }
}

