/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.iceberg.flink.FlinkTypeVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class FlinkTypeToType
extends FlinkTypeVisitor<Type> {
    private final FieldsDataType root;
    private int nextId = 0;

    FlinkTypeToType(FieldsDataType root) {
        this.root = root;
        this.nextId = root.getFieldDataTypes().size();
    }

    private int getNextId() {
        int next = this.nextId++;
        return next;
    }

    @Override
    public Type fields(FieldsDataType fields, List<Type> types) {
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)types.size());
        boolean isRoot = this.root == fields;
        List rowFields = ((RowType)fields.getLogicalType()).getFields();
        Preconditions.checkArgument((rowFields.size() == types.size() ? 1 : 0) != 0, (Object)"fields list and types list should have same size.");
        for (int i = 0; i < rowFields.size(); ++i) {
            int id = isRoot ? i : this.getNextId();
            RowType.RowField field = (RowType.RowField)rowFields.get(i);
            String name = field.getName();
            String comment = field.getDescription().orElse(null);
            if (field.getType().isNullable()) {
                newFields.add(Types.NestedField.optional((int)id, (String)name, (Type)types.get(i), (String)comment));
                continue;
            }
            newFields.add(Types.NestedField.required((int)id, (String)name, (Type)types.get(i), (String)comment));
        }
        return Types.StructType.of((List)newFields);
    }

    @Override
    public Type collection(CollectionDataType collection, Type elementType) {
        if (collection.getElementDataType().getLogicalType().isNullable()) {
            return Types.ListType.ofOptional((int)this.getNextId(), (Type)elementType);
        }
        return Types.ListType.ofRequired((int)this.getNextId(), (Type)elementType);
    }

    @Override
    public Type map(KeyValueDataType map, Type keyType, Type valueType) {
        if (map.getValueDataType().getLogicalType().isNullable()) {
            return Types.MapType.ofOptional((int)this.getNextId(), (int)this.getNextId(), (Type)keyType, (Type)valueType);
        }
        return Types.MapType.ofRequired((int)this.getNextId(), (int)this.getNextId(), (Type)keyType, (Type)valueType);
    }

    @Override
    public Type atomic(AtomicDataType type) {
        LogicalType inner = type.getLogicalType();
        if (inner instanceof VarCharType || inner instanceof CharType) {
            return Types.StringType.get();
        }
        if (inner instanceof BooleanType) {
            return Types.BooleanType.get();
        }
        if (inner instanceof IntType || inner instanceof SmallIntType || inner instanceof TinyIntType) {
            return Types.IntegerType.get();
        }
        if (inner instanceof BigIntType) {
            return Types.LongType.get();
        }
        if (inner instanceof VarBinaryType) {
            return Types.BinaryType.get();
        }
        if (inner instanceof BinaryType) {
            BinaryType binaryType = (BinaryType)inner;
            return Types.FixedType.ofLength((int)binaryType.getLength());
        }
        if (inner instanceof FloatType) {
            return Types.FloatType.get();
        }
        if (inner instanceof DoubleType) {
            return Types.DoubleType.get();
        }
        if (inner instanceof DateType) {
            return Types.DateType.get();
        }
        if (inner instanceof TimeType) {
            return Types.TimeType.get();
        }
        if (inner instanceof TimestampType) {
            return Types.TimestampType.withoutZone();
        }
        if (inner instanceof LocalZonedTimestampType) {
            return Types.TimestampType.withZone();
        }
        if (inner instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)inner;
            return Types.DecimalType.of((int)decimalType.getPrecision(), (int)decimalType.getScale());
        }
        throw new UnsupportedOperationException("Not a supported type: " + type.toString());
    }
}

