/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.FlinkTypeToType;
import org.apache.iceberg.flink.FlinkTypeVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;

public class FlinkSchemaUtil {
    private FlinkSchemaUtil() {
    }

    public static Schema convert(TableSchema schema) {
        Preconditions.checkArgument((boolean)(schema.toRowDataType() instanceof FieldsDataType), (Object)"Should be FieldsDataType");
        FieldsDataType root = (FieldsDataType)schema.toRowDataType();
        Type converted = FlinkTypeVisitor.visit((DataType)root, new FlinkTypeToType(root));
        return new Schema(converted.asStructType().fields());
    }
}

