/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.source.FlinkInputFormat;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class FlinkSource {
    private FlinkSource() {
    }

    public static Builder forRowData() {
        return new Builder();
    }

    private static boolean isBounded(ScanContext context) {
        return context.startSnapshotId() == null || context.endSnapshotId() != null;
    }

    public static boolean isBounded(Map<String, String> properties) {
        return FlinkSource.isBounded(new ScanContext().fromProperties(properties));
    }

    public static class Builder {
        private StreamExecutionEnvironment env;
        private Table table;
        private TableLoader tableLoader;
        private TableSchema projectedSchema;
        private ScanContext context = new ScanContext();
        private RowDataTypeInfo rowTypeInfo;

        public Builder tableLoader(TableLoader newLoader) {
            this.tableLoader = newLoader;
            return this;
        }

        public Builder table(Table newTable) {
            this.table = newTable;
            return this;
        }

        public Builder env(StreamExecutionEnvironment newEnv) {
            this.env = newEnv;
            return this;
        }

        public Builder filters(List<Expression> filters) {
            this.context = this.context.filterRows(filters);
            return this;
        }

        public Builder project(TableSchema schema) {
            this.projectedSchema = schema;
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.context = this.context.fromProperties(properties);
            return this;
        }

        public Builder caseSensitive(boolean caseSensitive) {
            this.context = this.context.setCaseSensitive(caseSensitive);
            return this;
        }

        public Builder snapshotId(Long snapshotId) {
            this.context = this.context.useSnapshotId(snapshotId);
            return this;
        }

        public Builder startSnapshotId(Long startSnapshotId) {
            this.context = this.context.startSnapshotId(startSnapshotId);
            return this;
        }

        public Builder endSnapshotId(Long endSnapshotId) {
            this.context = this.context.endSnapshotId(endSnapshotId);
            return this;
        }

        public Builder asOfTimestamp(Long asOfTimestamp) {
            this.context = this.context.asOfTimestamp(asOfTimestamp);
            return this;
        }

        public Builder splitSize(Long splitSize) {
            this.context = this.context.splitSize(splitSize);
            return this;
        }

        public Builder splitLookback(Integer splitLookback) {
            this.context = this.context.splitLookback(splitLookback);
            return this;
        }

        public Builder splitOpenFileCost(Long splitOpenFileCost) {
            this.context = this.context.splitOpenFileCost(splitOpenFileCost);
            return this;
        }

        public Builder nameMapping(String nameMapping) {
            this.context = this.context.nameMapping(nameMapping);
            return this;
        }

        public FlinkInputFormat buildFormat() {
            EncryptionManager encryption;
            FileIO io;
            Schema icebergSchema;
            block15: {
                Preconditions.checkNotNull((Object)this.tableLoader, (Object)"TableLoader should not be null");
                if (this.table == null) {
                    this.tableLoader.open();
                    try (TableLoader loader = this.tableLoader;){
                        this.table = loader.loadTable();
                        icebergSchema = this.table.schema();
                        io = this.table.io();
                        encryption = this.table.encryption();
                        break block15;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                icebergSchema = this.table.schema();
                io = this.table.io();
                encryption = this.table.encryption();
            }
            this.rowTypeInfo = RowDataTypeInfo.of((RowType)((RowType)(this.projectedSchema == null ? FlinkSchemaUtil.toSchema(FlinkSchemaUtil.convert(icebergSchema)) : this.projectedSchema).toRowDataType().getLogicalType()));
            this.context = this.context.project(this.projectedSchema == null ? icebergSchema : FlinkSchemaUtil.convert(icebergSchema, this.projectedSchema));
            return new FlinkInputFormat(this.tableLoader, icebergSchema, io, encryption, this.context);
        }

        public DataStream<RowData> build() {
            Preconditions.checkNotNull((Object)this.env, (Object)"StreamExecutionEnvironment should not be null");
            FlinkInputFormat format = this.buildFormat();
            if (FlinkSource.isBounded(this.context)) {
                return this.env.createInput((InputFormat)format, (TypeInformation)this.rowTypeInfo);
            }
            throw new UnsupportedOperationException("The Unbounded mode is not supported yet");
        }
    }
}

