/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.encryption.EncryptedInputFile;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

abstract class DataIterator<T>
implements CloseableIterator<T> {
    private Iterator<FileScanTask> tasks;
    private final Map<String, InputFile> inputFiles;
    private CloseableIterator<T> currentIterator;

    DataIterator(CombinedScanTask task, FileIO io, EncryptionManager encryption) {
        this.tasks = task.files().iterator();
        HashMap keyMetadata = Maps.newHashMap();
        task.files().stream().flatMap(fileScanTask -> Stream.concat(Stream.of(fileScanTask.file()), fileScanTask.deletes().stream())).forEach(file -> keyMetadata.put(file.path().toString(), file.keyMetadata()));
        Stream<EncryptedInputFile> encrypted = keyMetadata.entrySet().stream().map(entry -> EncryptedFiles.encryptedInput((InputFile)io.newInputFile((String)entry.getKey()), (ByteBuffer)((ByteBuffer)entry.getValue())));
        Iterable decryptedFiles = encryption.decrypt(encrypted::iterator);
        ImmutableMap.Builder inputFileBuilder = ImmutableMap.builder();
        decryptedFiles.forEach(decrypted -> inputFileBuilder.put((Object)decrypted.location(), decrypted));
        this.inputFiles = inputFileBuilder.build();
        this.currentIterator = CloseableIterator.empty();
    }

    InputFile getInputFile(FileScanTask task) {
        Preconditions.checkArgument((!task.isDataTask() ? 1 : 0) != 0, (Object)"Invalid task type");
        return this.inputFiles.get(task.file().path().toString());
    }

    InputFile getInputFile(String location) {
        return this.inputFiles.get(location);
    }

    public boolean hasNext() {
        this.updateCurrentIterator();
        return this.currentIterator.hasNext();
    }

    public T next() {
        this.updateCurrentIterator();
        return (T)this.currentIterator.next();
    }

    private void updateCurrentIterator() {
        try {
            while (!this.currentIterator.hasNext() && this.tasks.hasNext()) {
                this.currentIterator.close();
                this.currentIterator = this.openTaskIterator(this.tasks.next());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    abstract CloseableIterator<T> openTaskIterator(FileScanTask var1) throws IOException;

    public void close() throws IOException {
        this.currentIterator.close();
        this.tasks = null;
    }
}

